{++

v c e r t e r r . p a s

Translation of vcerterr.h, converted by htrans 0.3.4
Copyright (c) 1997 Alexander Staubo, all rights reserved.

[Generated on 17-10-2002 at 18:17]

--}

unit Vcerterr;

{$ALIGN ON}
{$MINENUMSIZE 4}

interface

function SUCCEEDED(Status: LongWord): Boolean;
function FAILED(Status: LongWord): Boolean;
function IS_ERROR(Status: LongWord): Boolean;
function VCERT_CODE(Status: LongWord): LongWord;
function VCERT_FACILITY(Status: LongWord): LongWord;
function VCERT_SEVERITY(Status: LongWord): LongWord;
function MAKE_VCERT_STATUS(sev, fac, code: LongWord): LongWord;
function VCERT_STATUS_FROM_WIN32(x: Integer): LongWord;
function VCERT_STATUS_FROM_OPENSSL(x: LongWord): LongWord;

type
  PPointer = ^Pointer;
  USHORT = Word;

(*
 * Copyright (c) VALIDATA 1999-2001. All rights reserved.
 * Module Name: vcerterr.h
 * Abstract: VCERT return codes
 *)
const
  VCERT_FACILITY_NT_BIT = $10000000;

(*
 * Map an OpenSSL error value into a VCERT status
 *)

const
  VCERT_FACILITY_OPENSSL_BIT = $28000000;

(*
 * Operation completed successefully
 *)

const
  VCERT_OK = 0;
    //
    //  Values are 32 bit values layed out as follows:
    //
    //   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
    //   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
    //  +-+-+-+-+-+---------------------+-------------------------------+
    //  |S|R|C|N|r|    Facility         |               Code            |
    //  +-+-+-+-+-+---------------------+-------------------------------+
    //
    //  where
    //
    //      S - Severity - indicates success/fail
    //
    //          0 - Success
    //          1 - Fail (COERROR)
    //
    //      R - reserved portion of the facility code, corresponds to NT's
    //              second severity bit.
    //
    //      C - reserved portion of the facility code, corresponds to NT's
    //              C field.
    //
    //      N - reserved portion of the facility code. Used to indicate a
    //              mapped NT status value.
    //
    //      r - reserved portion of the facility code. Reserved for internal
    //              use. Used to indicate HRESULT values that are not status
    //              values, but are instead message ids for display strings.
    //
    //      Facility - is the facility code
    //
    //      Code - is the facility's status code
    //
    //
    // Define the facility codes
    //
  VCERT_FACILITY_WIN32 = $7;
  VCERT_FACILITY_VALXMLPP = $81;
  VCERT_FACILITY_USER = $60;
  VCERT_FACILITY_SYSTEM = $0;
  VCERT_FACILITY_SERVICE = $40;
  VCERT_FACILITY_SECURITY = $20;
  VCERT_FACILITY_OPENSSL = $80;
  VCERT_FACILITY_LOGGING = $30;
  VCERT_FACILITY_LOCAL3 = $73;
  VCERT_FACILITY_LIBXML = $82;
  VCERT_FACILITY_KERNEL = $10;
  VCERT_FACILITY_CRYSRV = $BB;
  VCERT_FACILITY_CRYPT = $70;
  VCERT_FACILITY_CRYMON = $AA;
  VCERT_FACILITY_CONFIG = $71;
  VCERT_FACILITY_APPLICATION = $50;
  VCERT_FACILITY_ADMIN = $72;
    //
    // Define the severity codes
    //
    //
    // MessageId: VCERT_E_DUMMY
    //
    // MessageText:
    //
    //  Dummy error - need this error so that mc puts the above defines
    //
  VCERT_E_DUMMY = $20000000;

(*
 * Crypto codes
 *)

  //
  // MessageId: VCERT_E_GENERIC
  //
  // MessageText:
  //
  //  Generic error
  //

const
  VCERT_E_GENERIC = $E0700001;
    //
    // MessageId: VCERT_E_INVALID_PARAMETER
    //
    // MessageText:
    //
    //  Invalid parameter
    //
  VCERT_E_INVALID_PARAMETER = $E0700002;
    //
    // MessageId: VCERT_E_INVALID_CONTEXT
    //
    // MessageText:
    //
    //  Invalid crypt context
    //
  VCERT_E_INVALID_CONTEXT = $E0700003;
    //
    // MessageId: VCERT_E_OPERATION_NOT_SUPPORTED
    //
    // MessageText:
    //
    //  Operation not supported
    //
  VCERT_E_OPERATION_NOT_SUPPORTED = $E0700004;
    //
    // MessageId: VCERT_E_INVALID_FLAG
    //
    // MessageText:
    //
    //  Invalid flag
    //
  VCERT_E_INVALID_FLAG = $E0700005;
    //
    // MessageId: VCERT_E_NO_MEMORY
    //
    // MessageText:
    //
    //  No memory
    //
  VCERT_E_NO_MEMORY = $E0700006;
    //
    // MessageId: VCERT_E_HASH
    //
    // MessageText:
    //
    //  Hash error
    //
  VCERT_E_HASH = $E0700007;
    //
    // MessageId: VCERT_E_CERT_USAGE
    //
    // MessageText:
    //
    //  Wrong certificate usage
    //
  VCERT_E_CERT_USAGE = $E0700008;
    //
    // MessageId: VCERT_E_CERT_FIND_PRIVATE_KEY
    //
    // MessageText:
    //
    //  Cannot find private key in certificate
    //
  VCERT_E_CERT_FIND_PRIVATE_KEY = $E0700009;
    //
    // MessageId: VCERT_E_PKCS7_SET_TYPE
    //
    // MessageText:
    //
    //  Cannot set PKCS#7 type
    //
  VCERT_E_PKCS7_SET_TYPE = $E070000A;
    //
    // MessageId: VCERT_E_PKCS7_ADD_SIGNATURE
    //
    // MessageText:
    //
    //  Cannot add signature to PKCS#7
    //
  VCERT_E_PKCS7_ADD_SIGNATURE = $E070000C;
    //
    // MessageId: VCERT_E_PKCS7_ADD_CERTIFICATE
    //
    // MessageText:
    //
    //  Cannot add certificate to PKCS#7
    //
  VCERT_E_PKCS7_ADD_CERTIFICATE = $E070000D;
    //
    // MessageId: VCERT_E_PKCS7_CONTENT_NEW
    //
    // MessageText:
    //
    //  Cannot create new content of PKCS#7
    //
  VCERT_E_PKCS7_CONTENT_NEW = $E070000E;
    //
    // MessageId: VCERT_E_PKCS7_D2I
    //
    // MessageText:
    //
    //     DER-  PKCS#7 
    // -     
    //
  VCERT_E_PKCS7_D2I = $E070000F;
    //
    // MessageId: VCERT_E_PKCS7_I2D
    //
    // MessageText:
    //
    //  ASN.1 coding of PKCS#7 error
    //
  VCERT_E_PKCS7_I2D = $E0700010;
    //
    // MessageId: VCERT_E_PKEY_NOT_GOST
    //
    // MessageText:
    //
    //         
    //      
    // 
    //
  VCERT_E_PKEY_NOT_GOST = $E0700011;
    //
    // MessageId: VCERT_E_SIGN
    //
    // MessageText:
    //
    //  Sign error
    //
  VCERT_E_SIGN = $E0700012;
    //
    // MessageId: VCERT_E_VERIFY_POLICY
    //
    // MessageText:
    //
    //  Error adding policy to verify
    //
  VCERT_E_VERIFY_POLICY = $E0700013;
    //
    // MessageId: VCERT_E_VERIFY_EXTKEYUSAGE
    //
    // MessageText:
    //
    //  Error adding ext keyusage to verify
    //
  VCERT_E_VERIFY_EXTKEYUSAGE = $E0700014;
    //
    // MessageId: VCERT_E_PKCS7_READ
    //
    // MessageText:
    //
    //  ASN.1 error - not PKCS#7
    //
  VCERT_E_PKCS7_READ = $E0700015;
    //
    // MessageId: VCERT_E_VERIFY
    //
    // MessageText:
    //
    //  Sign verify error
    //
  VCERT_E_VERIFY = $E0700019;
    //
    // MessageId: VCERT_E_VERIFY_FORMAT
    //
    // MessageText:
    //
    //  Message not signed or damaged
    //
  VCERT_E_VERIFY_FORMAT = $E070001A;
    //
    // MessageId: VCERT_E_DELETE_SIGN
    //
    // MessageText:
    //
    //  Error deleting sign
    //
  VCERT_E_DELETE_SIGN = $E070001B;
    //
    // MessageId: VCERT_E_PKCS7_SET_CIPHER
    //
    // MessageText:
    //
    //  Error PKCS#7 set cipher
    //
  VCERT_E_PKCS7_SET_CIPHER = $E070001D;
    //
    // MessageId: VCERT_E_PKCS7_SET_CIPHER_INFO
    //
    // MessageText:
    //
    //  Error PKCS#7 set cipher info (sender)
    //
  VCERT_E_PKCS7_SET_CIPHER_INFO = $E070001E;
    //
    // MessageId: VCERT_E_PKCS7_ADD_RECIPIENT
    //
    // MessageText:
    //
    //  Error PKCS#7 add recpient
    //
  VCERT_E_PKCS7_ADD_RECIPIENT = $E070001F;
    //
    // MessageId: VCERT_E_PKCS7_ENCRYPT
    //
    // MessageText:
    //
    //  Error PKCS#7 encrypt
    //
  VCERT_E_PKCS7_ENCRYPT = $E0700020;
    //
    // MessageId: VCERT_E_ENCRYPT
    //
    // MessageText:
    //
    //  Error encrypt
    //
  VCERT_E_ENCRYPT = $E0700021;
    //
    // MessageId: VCERT_E_PKCS7_WRONG_TYPE
    //
    // MessageText:
    //
    //  Wrong PKCS#7 type
    //
  VCERT_E_PKCS7_WRONG_TYPE = $E0700022;
    //
    // MessageId: VCERT_E_EVP_GET_CIPHER
    //
    // MessageText:
    //
    //  Decrypt method unsupported
    //
  VCERT_E_EVP_GET_CIPHER = $E0700023;
    //
    // MessageId: VCERT_E_DECRYPT_NO_RECIPIENTS
    //
    // MessageText:
    //
    //  No decrypt recipients found
    //
  VCERT_E_DECRYPT_NO_RECIPIENTS = $E0700024;
    //
    // MessageId: VCERT_E_DECRYPT_NO_SENDER
    //
    // MessageText:
    //
    //  No decrypt sender cert found
    //
  VCERT_E_DECRYPT_NO_SENDER = $E0700025;
    //
    // MessageId: VCERT_E_DECRYPT_NO_RECIPIENT
    //
    // MessageText:
    //
    //  No decrypt recipient cert found
    //
  VCERT_E_DECRYPT_NO_RECIPIENT = $E0700026;
    //
    // MessageId: VCERT_E_PKCS7_DECRYPT
    //
    // MessageText:
    //
    //  Error PKCS#7 decrypt
    //
  VCERT_E_PKCS7_DECRYPT = $E0700027;
    //
    // MessageId: VCERT_E_DECRYPT
    //
    // MessageText:
    //
    //  Decrypt error
    //
  VCERT_E_DECRYPT = $E0700028;
    //
    // MessageId: VCERT_E_RANDOM
    //
    // MessageText:
    //
    //  Random generation error
    //
  VCERT_E_RANDOM = $E0700029;
    //
    // MessageId: VCERT_E_OPEN_CONFIG
    //
    // MessageText:
    //
    //  Config open error
    //
  VCERT_E_OPEN_CONFIG = $E071002A;
    //
    // MessageId: VCERT_E_READ_CONFIG
    //
    // MessageText:
    //
    //  Config parsing error
    //
  VCERT_E_READ_CONFIG = $E071002B;
    //
    // MessageId: VCERT_E_NO_DEFAULT_CONFIG
    //
    // MessageText:
    //
    //  Default profile not defined in config
    //
  VCERT_E_NO_DEFAULT_CONFIG = $E071002C;
    //
    // MessageId: VCERT_E_OPEN_PSE
    //
    // MessageText:
    //
    //  Open PSE error
    //
  VCERT_E_OPEN_PSE = $E070002D;
    //
    // MessageId: VCERT_E_OPEN_LOCALSTORE
    //
    // MessageText:
    //
    //  Open Local Store error
    //
  VCERT_E_OPEN_LOCALSTORE = $E070002E;
    //
    // MessageId: VCERT_E_VERIFY_STORE_USAGE
    //
    // MessageText:
    //
    //  Store usage verify error
    //
  VCERT_E_VERIFY_STORE_USAGE = $E070002F;
    //
    // MessageId: VCERT_E_VERIFY_STORE
    //
    // MessageText:
    //
    //  Verify PSE integrity error
    //
  VCERT_E_VERIFY_STORE = $E0700030;
  VCERT_E_OPEN_LDAPSTORE = $E0700031;
  VCERT_E_NO_STREAM_DATA = $E0700032;
  VCERT_E_BAD_STREAM_EOC = $E0700033;
    //
    // MessageId: VCERT_E_VERIFY_CERT
    //
    // MessageText:
    //
    //  Verify certificate error
    //
  VCERT_E_VERIFY_CERT = $E0700034;
    //
    // MessageId: VCERT_E_CERT_MISSING
    //
    // MessageText:
    //
    //  Certificate not found
    //
  VCERT_E_CERT_MISSING = $E0700035;
    //
    // MessageId: VCERT_E_CERT_EXPIRED
    //
    // MessageText:
    //
    //  Certificate expired
    //
  VCERT_E_CERT_EXPIRED = $E0700036;
    //
    // MessageId: VCERT_E_CERT_DAMAGED
    //
    // MessageText:
    //
    //  Certificate damaged
    //
  VCERT_E_CERT_DAMAGED = $E0700037;

  VCERT_E_CERT_BROKEN_CONSTRAINT = $E0700038;
    //
    // MessageId: VCERT_E_CERT_REVOKED
    //
    // MessageText:
    //
    //  Certificate revoked
    //
  VCERT_E_CERT_REVOKED = $E0700039;
    //
    // MessageId: VCERT_E_CERT_UNTRUSTED
    //
    // MessageText:
    //
    //  Certificate untrusted
    //
  VCERT_E_CERT_UNTRUSTED = $E070003A;
    //
    // MessageId: VCERT_E_CRL_MISSING
    //
    // MessageText:
    //
    //  CRL missing
    //
  VCERT_E_CRL_MISSING = $E070003B;
    //
    // MessageId: VCERT_E_CRL_EXPIRED
    //
    // MessageText:
    //
    //  CRL expired
    //
  VCERT_E_CRL_EXPIRED = $E070003C;
    //
    // MessageId: VCERT_E_CRL_DAMAGED
    //
    // MessageText:
    //
    //  CRL damaged
    //
  VCERT_E_CRL_DAMAGED = $E070003D;

  VCERT_E_CERT_BROKEN_HIERARCHY = $E070003E;
    //
    // MessageId: VCERT_E_CHAIN_ERROR
    //
    // MessageText:
    //
    //  Verification chain build error
    //
  VCERT_E_CHAIN_ERROR = $E070003F;
    //
    // MessageId: VCERT_E_TOO_MUCH_CERT
    //
    // MessageText:
    //
    //  Too much objects in verification chain
    //
  VCERT_E_TOO_MUCH_CERT = $E0700040;
    //
    // MessageId: VCERT_E_INVALID_USAGE
    //
    // MessageText:
    //
    //  Invalid certificate usage
    //
  VCERT_E_INVALID_USAGE = $E0700041;
    //
    // MessageId: VCERT_E_INVALID_SIGNATURE
    //
    // MessageText:
    //
    //  Invalid signature
    //
  VCERT_E_INVALID_SIGNATURE = $E0700042;
    //
    // MessageId: VCERT_E_OPENKEY_NOT_FOUND
    //
    // MessageText:
    //
    //  Open key not found
    //
  VCERT_E_OPENKEY_NOT_FOUND = $E0700043;
    //
    // MessageId: VCERT_E_SELFCHECK
    //
    // MessageText:
    //
    //  Selfcheck error
    //
  VCERT_E_SELFCHECK = $E0700044;
    //
    // MessageId: VCERT_E_UPDATECRL
    //
    // MessageText:
    //
    //  Update CRL error
    //
  VCERT_E_UPDATECRL = $E0700045;
    //
    // MessageId: VCERT_E_CERT_NOT_FOUND
    //
    // MessageText:
    //
    //  Certificate not found
    //
  VCERT_E_CERT_NOT_FOUND     = $E0700046;
  VCERT_E_CERT_NOT_YET_VALID = $E0700047;
  VCERT_E_REQ_NOT_FOUND      = $E0700048;
    //
    // MessageId: VCERT_E_PKCS7_WRONG_ALGORITHM
    //
    // MessageText:
    //
    //        PKCS#7,
    //  ,     ,
    //      
    // 
    //
  VCERT_E_PKCS7_WRONG_ALGORITHM = $E0700049;
  VCERT_E_KEY_EXPIRED        = $E070004C;
  VCERT_E_KEY_NOT_YET_VALID  = $E070004D;
  VCERT_E_CRL_NOT_YET_VALID  = $E070004E;

    //
    // MessageId: VCERT_E_INIT_CSP
    //
    // MessageText:
    //
    //  CSP initialization error
    //
  VCERT_E_INIT_CSP = $E070004F;
    //
    // MessageId: VCERT_E_SIGN_INIT
    //
    // MessageText:
    //
    //  Init GOST sign
    //
  VCERT_E_SIGN_INIT = $E0700053;
    //
    // MessageId: VCERT_E_CRYPTO_INIT
    //
    // MessageText:
    //
    //  Init GOST crypto
    //
  VCERT_E_CRYPTO_INIT = $E0700054;
    //
    // MessageId: VCERT_E_OPEN_PROFILES_KEY
    //
    // MessageText:
    //
    //  Profiles key open error
    //
  VCERT_E_OPEN_PROFILES_KEY = $E070005F;
    //
    // MessageId: VCERT_E_FIND_SESSION
    //
    // MessageText:
    //
    //  Cryptoserver session not found
    //
  VCERT_E_FIND_SESSION = $E0700081;
    //
    // MessageId: VCERT_E_SIGNLEN
    //
    // MessageText:
    //
    //  Signature length is wrong
    //
  VCERT_E_SIGNLEN = $E0700082;
    //
    // MessageId: VCERT_E_DECRYPT_FORMAT
    //
    // MessageText:
    //
    //  Message is not encrypted or damaged
    //
  VCERT_E_DECRYPT_FORMAT = $E0700083;
    //
    // MessageId: VCERT_E_ADD_OBJECT
    //
    // MessageText:
    //
    //  Add object to store error
    //
  VCERT_E_ADD_OBJECT = $E0700087;
    //
    // MessageId: VCERT_E_TOO_MANY_CERTS_FOUND
    //
    // MessageText:
    //
    //  Too many certificates found
    //
  VCERT_E_TOO_MANY_CERTS_FOUND = $E0720089;
    //
    // MessageId: VCERT_E_USER_CANCEL
    //
    // MessageText:
    //
    //  Operation cancelled by user
    //
  VCERT_E_USER_CANCEL = $E072008A;
    //
    // MessageId: VCERT_E_OPEN_INFILE
    //
    // MessageText:
    //
    //  Open input file error
    //
  VCERT_E_OPEN_INFILE = $E070008B;
    //
    // MessageId: VCERT_E_OPEN_OUTFILE
    //
    // MessageText:
    //
    //  Open output file error
    //
  VCERT_E_OPEN_OUTFILE = $E070008C;
    //
    // MessageId: VCERT_E_READ_FILE
    //
    // MessageText:
    //
    //  Read file error
    //
  VCERT_E_READ_FILE = $E070008D;
    //
    // MessageId: VCERT_E_WRITE_FILE
    //
    // MessageText:
    //
    //  Write file error
    //
  VCERT_E_WRITE_FILE = $E070008E;
    //
    // MessageId: VCERT_E_FILE_LENGTH
    //
    // MessageText:
    //
    //  Wrong file length
    //
  VCERT_E_FILE_LENGTH = $E070008F;
    //
    // MessageId: VCERT_E_FILE_MAPPING
    //
    // MessageText:
    //
    //  File memory-mapping error
    //
  VCERT_E_FILE_MAPPING = $E0700090;

  VCERT_E_DELETE_OBJECT      = $E0700091;
  VCERT_E_INSUFFICIENT_SIGNS = $E0700092;
  VCERT_E_VERIFY_CRL         = $E0700093;
  VCERT_E_GET_PUBKEY         = $E0700094;
  VCERT_E_REQ_NEW            = $E0700098;
  VCERT_E_REQ_SIGN           = $E070009A;
  VCERT_E_MAKE_REVREQ        = $E070009B;
  VCERT_E_SIGN_REVREQ        = $E070009C;
  VCERT_E_LOAD_PRIVATE_KEY   = $E070009D;
  VCERT_E_ADD_SIGNER         = $E070009E;
  VCERT_E_PKCS7_DATA_INIT    = $E070009F;
  VCERT_E_BIO_WRITE          = $E07000A0;
  VCERT_E_OPEN_IDP           = $E07000A1;
  VCERT_E_READ_IDP           = $E07000A2;
  VCERT_E_SESSIONCORRUPTED   = $E07000A3;
  VCERT_E_MAC                = $E07000A4;
  VCERT_E_CRYPT              = $E07000A5;
  VCERT_E_SPOOFING           = $E07000A6;
  VCERT_E_CERTDONOTMATCH     = $E07000A7;
  VCERT_E_XMLINIT            = $E07000A8;
  VCERT_E_INVALID_CREDENTIALS= $E02000A8;
  VCERT_E_ACCESS_DENIED      = $E02000A9;
  VCERT_E_SESSION_BLOCKED    = $A02000AA;
  VCERT_E_CLIENT_INFO        = $E02000AB;
  VCERT_E_UNSECURE_CREDENTIALS = $E02000AC;
  VCERT_E_RESIGN_PROHIBIT    = $E02000AD;
  VCERT_E_TSP_HASH_LENGTH    = $E0700100;
  VCERT_E_TSP_HASH_ALGORITHM = $E0700101;
  VCERT_E_TSP_CERT_PURPOSE   = $E0700102;
  VCERT_E_TSP_SIGN_FAILED    = $E0700103;
  VCERT_E_TSP_NO_DIGEST      = $E0700104;
  VCERT_E_TSP_INVALID_SIGNER_NUM = $E0700105;
  VCERT_E_TSP_NO_TST_INFO    = $E0700106;
  VCERT_E_TSP_RESP_D2I       = $E0700107;
  VCERT_E_TSP_RESP_NOT_ISSUED= $E0700108;
  VCERT_E_TSP_DIGEST_MISMATCH= $E0700109;
  VCERT_E_OCSP_CERT_PURPOSE  = $E0700140;
  VCERT_E_OCSP_SIGN_FAILED   = $E0700141;
  VCERT_E_OCSP_RESP_D2I      = $E0700142;
  VCERT_E_OCSP_RESP_NOT_ISSUED=$E0700143;
  VCERT_E_OCSP_NOT_BASICRESP = $E0700144;
  VCERT_E_OCSP_CERTID_MISMATCH=$E0700145;
  VCERT_E_OCSP_ISSUER_MISMATCH=$E0700146;

implementation

(*
 * Generic test for success on any status value (non-negative numbers
 * indicate success).
 *)
function SUCCEEDED(Status: LongWord): Boolean;
begin
  Result := Integer(Status) >= 0;
end;

(*
 * and the inverse
 *)
function FAILED(Status: LongWord): Boolean;
begin
  Result := Integer(Status) < 0;
end;

(*
 * Generic test for error on any status value.
 *)
function IS_ERROR(Status: LongWord): Boolean;
begin
  Result := Status and $80000000 <> 0;
end;

(*
 * Return the code
 *)
function VCERT_CODE(Status: LongWord): LongWord;
begin
  Result := Status and $FFFF;
end;

(*
 *  Return the facility
 *)
function VCERT_FACILITY(Status: LongWord): LongWord;
begin
  Result := (Status shr 16) and $1FFF;
end;

(*
 *  Return the severity
 *)
function VCERT_SEVERITY(Status: LongWord): LongWord;
begin
  Result := (Status shr 31) and $1;
end;

(*
 * Create an VCERT status value from component pieces
 *)
function MAKE_VCERT_STATUS(sev, fac, code: LongWord): LongWord;
begin
  Result := (sev shl 31) or (1 shl 29) or (fac shl 16) or code;
end;

(*
 * Map a WIN32 error value into a VCERT status
 * Note: This assumes that WIN32 errors fall in the range -32k to 32k.
 *
 *)
function VCERT_STATUS_FROM_WIN32(x: Integer): LongWord;
begin
  if x <> 0 then
    Result := (LongWord(x) and $0000FFFF) or (VCERT_FACILITY_WIN32 shl 16) or $80000000
  else
    Result := 0;
end;

(*
 * Map an NT status value into a VCERT status
 *)
function VCERT_STATUS_FROM_NT(x: LongWord): LongWord;
begin
  Result := x or VCERT_FACILITY_NT_BIT; {@@@ FACILITY_NT_BIT in vcerterr.h???}
end;

(*
 * Map an OpenSSL error value into a VCERT status
 *)
function VCERT_STATUS_FROM_OPENSSL(x: LongWord): LongWord;
begin
  Result := x or VCERT_FACILITY_OPENSSL_BIT;  {@@@ FACILITY_OPENSSL_BIT in vcerterr.h???}
end;

end.

