// ************************************************************************ //
// The types declared in this file were generated from data read from the
// WSDL File described below:
// WSDL     : P:\soap\WslService.xml
// Encoding : UTF-8
// Version  : 1.0
// (30.07.2009 16:38:01 - 1.33.2.5)
// ************************************************************************ //

unit WslService;

interface

uses SysUtils, Classes, InvokeRegistry, SOAPHTTPClient, Types, XSBuiltIns, opCOnvertOptions, XMLIntf, WEBSUlil,
  SOAPAttach, SOAPDomConv, SOAPAttachIntf;
const
  IS_OPTN = $0001;
  IS_NLBL = $0004;
  IS_UNQL = $0008;
type

  // ************************************************************************ //
  // The following types, referred to in the WSDL document are not being represented
  // in this file. They are either aliases[@] of other types represented or were referred
  // to but never[!] declared in the document. The types from the latter category
  // typically map to predefined/known XML or Borland types; however, they could also
  // indicate incorrect WSDL documents that failed to declare or import a schema type.
  // ************************************************************************ //
  // !:string          - "http://www.w3.org/2001/XMLSchema"
  // !:int             - "http://www.w3.org/2001/XMLSchema"

  packageIdList        = class;                 { "http://wslouch.micex.com/" }
  package              = class;                 { "http://wslouch.micex.com/" }
  outObj               = class;                 { "http://wslouch.micex.com/" }
  data                = class;                 { "http://wslouch.micex.com/" }
  faultInfo2           = class;                 { "http://wslouch.micex.com/"[GblCplx] }
  FaultInfo            = class;                 { "http://wslouch.micex.com/"[Flt][GblElm] }


  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  {orderState = class(TRemotable)
  private
    ForderState: WideString;
    FerrorCode: Integer;
    FerrorDesc: WideString;
  published
    property orderState: WideString read ForderState write ForderState;
    property errorCode: Integer read FerrorCode write FerrorCode;
    property errorDesc: WideString read FerrorDesc write FerrorDesc;
  end;}



  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  packageIdList = class(TRemotable)
  private
    FpackageIdList: WideString;
    FerrorCode: Integer;
    FerrorDesc: WideString;
  published
    property packageIdList: WideString read FpackageIdList write FpackageIdList;
    property errorCode: Integer read FerrorCode write FerrorCode;
    property errorDesc: WideString read FerrorDesc write FerrorDesc;
  end;



  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  package = class(TRemotable)
  private
    FpackageBody: WideString;
    FerrorCode: Integer;
    FerrorDesc: WideString;
  published
    property packageBody: WideString read FpackageBody write FpackageBody;
    property errorCode: Integer read FerrorCode write FerrorCode;
    property errorDesc: WideString read FerrorDesc write FerrorDesc;
  end;



  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  {rests = class(TRemotable)
  private
    Frests: WideString;
    FerrorCode: Integer;
    FerrorDesc: WideString;
  published
    property rests: WideString read Frests write Frests;
    property errorCode: Integer read FerrorCode write FerrorCode;
    property errorDesc: WideString read FerrorDesc write FerrorDesc;
  end;

  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  assets = class(TRemotable)
  private
    Fassets: WideString;
    FerrorCode: Integer;
    FerrorDesc: WideString;
  published
    property assets: WideString read FAssets write FAssets;
    property errorCode: Integer read FerrorCode write FerrorCode;
    property errorDesc: WideString read FerrorDesc write FerrorDesc;
  end;}

   // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  data = class(TRemotable)
  private
    Fdata: WideString;
    Ffaultcode: Integer;
    Ffaultstring: WideString;
    //Fdata: TSoapAttachment;
  published
    //property data: WideString read Fdata write Fdata;
    property faultcode: Integer read Ffaultcode write Ffaultcode;
    property faultstring: WideString read Ffaultstring write Ffaultstring;
    property data: WideString read Fdata write Fdata;
  end;

  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  outObj = class(TRemotable)
  private
    FerrorCode: Integer;
    FerrorDesc: WideString;
  published
    property errorCode: Integer read FerrorCode write FerrorCode;
    property errorDesc: WideString read FerrorDesc write FerrorDesc;
  end;


  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  InAttachment = class(TRemotable)
  private
    Fdata: TSoapAttachment;
  published
    destructor Destroy; override;
    property data: TSoapAttachment read Fdata write Fdata;
  end;

  // ************************************************************************ //
  // Namespace : http://wslouch.micex.com/
  // transport : http://schemas.xmlsoap.org/soap/http
  // style     : document
  // binding   : WslPortBinding
  // service   : WslService
  // port      : WslPort
  // URL       : http://jerry:8081/WsLouch/WslService
  // ************************************************************************ //
// ************************************************************************ //
  // XML       : faultInfo, global, <complexType>
  // Namespace : http://wslouch.micex.com/
  // ************************************************************************ //
  faultInfo2 = class(TRemotable)
  private
    FerrorCode: Integer;
    FerrorDesc: string;
    FerrorDesc_Specified: boolean;
    procedure SeterrorDesc(Index: Integer; const Astring: string);
    function  errorDesc_Specified(Index: Integer): boolean;
  published
    property errorCode: Integer  Index (IS_UNQL) read FerrorCode write FerrorCode;
    property errorDesc: string   Index (IS_OPTN or IS_UNQL) read FerrorDesc write SeterrorDesc stored errorDesc_Specified;
  end;



  // ************************************************************************ //
  // XML       : FaultInfo, global, <element>
  // Namespace : http://wslouch.micex.com/
  // Info      : Fault
  // Base Types: faultInfo
  // ************************************************************************ //
  FaultInfo = class(ERemotableException)
  private
    FerrorCode: Integer;
    FerrorDesc: string;
    FerrorDesc_Specified: boolean;
    procedure SeterrorDesc(Index: Integer; const Astring: string);
    function  errorDesc_Specified(Index: Integer): boolean;
  published
    property errorCode: Integer  Index (IS_UNQL) read FerrorCode write FerrorCode;
    property errorDesc: string   Index (IS_OPTN or IS_UNQL) read FerrorDesc write SeterrorDesc stored errorDesc_Specified;
  end;

  Wsl = interface(IInvokable)
  ['{7E0B1B96-EBB9-C4C5-3B5C-6CAF4C0AEDC8}']
    function  GetRests(const PersonCode: WideString; const DepositCode: WideString; const SearchPersonCode: WideString;
                       const AccountCode: WideString; const SectionCode: WideString; const SecurityCode: WideString): data; stdcall;
    function  GetOrderState(const PersonCode: WideString; const DepositCode: WideString; const RegNo: WideString): data; stdcall;
    function  GetPackageList(const PersonCode: WideString; const Date: WideString): data; stdcall;
    function  GetPackage(const PersonCode: WideString; const PackageId: WideString; const PartNumber: Integer;
                         const PartsQuantity: Integer): InAttachment; stdcall;
    function  InitTransferIn(const PersonCode: WideString; const PackageFileName: WideString): data; stdcall;
    function  PutPackage(const PersonCode: WideString; const PackageId: WideString; const PartNumber: Integer; const PartsQuantity: Integer;
                          const PackageBody: TSoapAttachment): data; stdcall;
    function  GetTransferResult(const PersonCode: WideString; const PackageId: WideString): outObj; stdcall;
    function  GetRestsRepo(const PersonCode: WideString; const AccountCode: WideString; const CorrSecTypeCode: WideString): data; stdcall;
    function  GetMarkedRests(const PersonCode: WideString; const DepositCode: WideString; const SearchPersonCode: WideString;
                             const AccountCode: WideString; const SectionCode: WideString; const SecurityCode: WideString;
                             const ActiveType: WideString): data; stdcall;

    function  GetRcCreditorAssets(const PersonCode: WideString; const DebitorCode: WideString; const CreditorCode: WideString; const CreditorFiCode: WideString;
                             const RateNoMore: WideString): data; stdcall;

    function  GetSUOPrices(const PersonCode: WideString; const AccountCode: WideString; const SecurityCode: WideString): data; stdcall;

    {   
     * @param mode -   .  :
     *             F1_F2,
     *             F2_F1,
     *             CSV_F2,
     *             F2_CSV.
     * @param inputPackage - ZIP ,     ,   .       .
     * @param partId -   .
     * @return     .
     *        :
     *              ?       report.xml - XML-   .  report.xml,
     *              ?       logview.xsl -    XML-   ,
     *              ?            .
     *           .
    }
    function ConvertReposDoc(const mode: string; const inputPackage: TSoapAttachment; const partId: string): InAttachment; stdcall;
  end;
function GetWsl(Addr: string=''; HTTPRIO: TNSDHTTPRIO = nil): Wsl; overload;


implementation

function GetWsl(Addr: string; HTTPRIO: TNSDHTTPRIO): Wsl;
var
  RIO: TNSDHTTPRIO;
begin
  Result := nil;
  if HTTPRIO = nil then RIO := TNSDHTTPRIO.Create(nil)
  else RIO := HTTPRIO;
  try
    Result := (RIO as Wsl);
    RIO.URL := Addr;
  finally
    if (Result = nil) and (HTTPRIO = nil) then RIO.Free;
  end;
end;

procedure faultInfo2.SeterrorDesc(Index: Integer; const Astring: string);
begin
  FerrorDesc := Astring;
  FerrorDesc_Specified := True;
end;

function faultInfo2.errorDesc_Specified(Index: Integer): boolean;
begin
  Result := FerrorDesc_Specified;
end;

procedure FaultInfo.SeterrorDesc(Index: Integer; const Astring: string);
begin
  FerrorDesc := Astring;
  FerrorDesc_Specified := True;
end;

function FaultInfo.errorDesc_Specified(Index: Integer): boolean;
begin
  Result := FerrorDesc_Specified;
end;

{ InAttachment }

destructor InAttachment.Destroy;
begin
  if Assigned(Fdata) then
    FreeAndNil(Fdata);
  inherited;
end;

initialization
  InvRegistry.RegisterInterface(TypeInfo(Wsl), 'http://wslouch.micex.com/', 'UTF-8');
  InvRegistry.RegisterDefaultSOAPAction(TypeInfo(Wsl), '');
  InvRegistry.RegisterInvokeOptions(TypeInfo(Wsl), ioDocument);
  RemClassRegistry.RegisterXSClass(packageIdList, 'http://wslouch.micex.com/', 'packageIdList');
  RemClassRegistry.RegisterXSClass(package, 'http://wslouch.micex.com/', 'package');
  RemClassRegistry.RegisterXSClass(outObj, 'http://wslouch.micex.com/', 'outObj');
  RemClassRegistry.RegisterXSClass(data, 'http://wslouch.micex.com/', 'data');
  RemClassRegistry.RegisterXSClass(faultInfo2, 'http://wslouch.micex.com/', 'faultInfo2', 'faultInfo');
  RemClassRegistry.RegisterXSClass(FaultInfo, 'http://wslouch.micex.com/', 'FaultInfo');
end.