unit WindowsZIP;
// ZIP-  Windows


interface
uses classes, TlHelp32, Dialogs;

// ZIP-.  :
//ZIPfile -  ( )  ;
//Files -  ,      
function WZIP_Make(ZIPfile: string; Files: TStringList): boolean;

//    .  :
//ZipFile -  ZIP-
// :      "separator"
function WZip_Content(ZipFile : string; separator : string = AnsiString(#13#10)) : string;

//    ZIP-.  
//DestDir - ,     .
//ZipFile -  ZIP-
//FileInZIP -    ,   
function WZIP_ExtractOneFile(DestDir, ZipFile, FileInZIP : string) : boolean;

//    ZIP-    .
// 
//DestDir - ,     .
//ZipFile -  ZIP-
function WZIP_ExtractAll(DestDir, ZipFile : string) : boolean;

// ZIP-  .  :
//ZIPfile -  ( )  ;
//DirSource -      
function WZIP_ZipDirAll(ZIPfile, DirSource : string): boolean;

function GetTempDir: String;
function GetMyTempDir(MyDirAdd : String): String;
//      
function DelDirFile(DirName : String; Mask : String) : Boolean;
//   
function KillDir(Dir: AnsiString): boolean;

implementation

Uses comobj, windows, variants, sysUtils;

procedure CreateEmptyZip(ZipFile : String);
const
  EmptyZip: array[0..23] of Byte  = (80, 75, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
var
  Ms: TMemoryStream;
begin
  Ms := TMemoryStream.Create;
  try
    Ms.WriteBuffer(EmptyZip, SizeOf(EmptyZip));
    Ms.SaveToFile(ZipFile);
  finally
    Ms.Free;
  end;
end;

function GetTempDir: String;
var
  Buffer : array[0..1023] of AnsiChar;

begin
  SetString(Result, Buffer, GetTempPathA(SizeOf(Buffer) - 1, Buffer));
  Result := IncludeTrailingPathDelimiter(Result);
end;

function GetMyTempDir(MyDirAdd : String): String;
Var
  S : String;
begin
  Result := '';
  S := GetTempDir + MyDirAdd;
  if ForceDirectories(S) then
  begin
    Result := S;
  end;
end;

function DelDirFile(DirName : String; Mask : String) : Boolean;
var
  FileSearch: TSearchRec;
begin
  Result := False;
  try
  if SysUtils.FindFirst(IncludeTrailingPathDelimiter(DirName) + Mask, 126, FileSearch) = 0 then
  begin
    repeat
      if (FileSearch.name <> '.') and (FileSearch.name <> '..') and
         ((FileSearch.attr and 126) <> 0) then
      begin
         SysUtils.DeleteFile(IncludeTrailingPathDelimiter(DirName) + FileSearch.Name);
      end;{if (FileSearch.name <> '.')}
    until FindNext(FileSearch) <> 0;
    SysUtils.FindClose(FileSearch);
  end;{if FindFirst(LastChar(DirName) + Mask, 126, FileSearch) = 0}
  Result := True;
  except
     on E: Exception do
     begin
       Exit;
     end;
  end;{try}
end;

function KillDir(Dir: AnsiString): boolean;
var
  Sr: SysUtils.TSearchRec;
begin
{$I-}
  if (Dir <> '') and (Dir[length(Dir)] = '\') then Delete(Dir, length(dir), 1);
  if FindFirst(Dir + '\*.*', faDirectory + faHidden + faSysFile +
    faReadonly + faArchive, Sr) = 0 then
    repeat
      if (Sr.Name = '.') or (Sr.Name = '..') then Continue;
      if (Sr.Attr and faDirectory <> faDirectory) then
      begin
        FileSetReadOnly(Dir + '\' + sr.Name, False);
        DeleteFile(Dir + '\' + sr.Name);
      end else KillDir(Dir + '\' + sr.Name);
    until FindNext(sr) <> 0;
  FindClose(sr);
  RemoveDir(Dir); //   
  KillDir := (FileGetAttr(Dir) = -1);
end;



function WZIP_Make(ZIPfile: string; Files: TStringList): boolean;
Var
  ms                     : TMemoryStream;
  ShellApp, ArchiveFolder       : variant;
  s, fn                  : string;
  i, k                   : integer;
  tfl,TempPath           : string;
begin
  result := false;
  for i := 0 to Files.Count -1 do
    if not FileExists(Files.Strings[i]) then Exit;

  SetLength(TempPath,255);
  i := GetTempPath(250,@TempPath[1]);
  SetLength(TempPath, i);
  if TempPath[Length(TempPath)] <> '\' then TempPath := TempPath + '\';

  s := ExtractFileExt(ZIPfile);
  if UpperCase(s) <> '.ZIP' then Exit;

  tfl := TempPath + ExtractFileName(ZIPfile);

  //+  
  CreateEmptyZip(tfl);
  try
    ShellApp := CreateOleObject('Shell.Application');
    ArchiveFolder := ShellApp.NameSpace((tfl));
    for i := 0 to Files.Count -1 do
      begin
        k := ArchiveFolder.Items.Count;
        ArchiveFolder.CopyHere(Files.Strings[i], 20);
        repeat
          sleep(100);
        until ArchiveFolder.Items.Count <> k;
      end;
  finally
    ShellApp := NULL;
    ArchiveFolder := NULL;
  end;
  //-  
  sleep(500);
  result := MoveFileEx(PChar(tfl),PChar(ZIPfile),MOVEFILE_REPLACE_EXISTING + MOVEFILE_COPY_ALLOWED);
end;

function WZIP_ZipDirAll(ZIPfile, DirSource : string): boolean;
Var
  tfl                    : string;
  ms                     : TMemoryStream;
  i, NumT : Integer;
  ShellApp, ArchiveFolder, objSourceFolderItems : variant;

begin
  result := false;
  tfl := ChangeFileExt(ZIPfile, '.zip');

  try
    try
      CreateEmptyZip(tfl);
      ShellApp := CreateOleObject('Shell.Application');
      ArchiveFolder := ShellApp.NameSpace((tfl));
      objSourceFolderItems :=  ShellApp.NameSpace(IncludeTrailingPathDelimiter(DirSource)).Items;
      ArchiveFolder.CopyHere(objSourceFolderItems, 20);
    Except
      Exit;
    end;
      Sleep(1000);
    result := True;
  finally
    ShellApp := NULL;
    ArchiveFolder := NULL;
    objSourceFolderItems := NULL;
  end;
end;

function WZip_Content(ZipFile : string; separator : string = #13#10) : String;
var
  objShellApp, objFolder, objItems : variant;
  i, n : integer;
begin
  result := '';
  if not FileExists(ZipFile) then
    exit;
  try
    try
      objShellApp := CreateOleObject('Shell.Application');
      objFolder :=  objShellApp.NameSpace((ZipFile));
      objItems := objFolder.Items;
      n := objItems.Count;
      for I := 0 to n-1 do
        begin
          result := result + objItems.Item((i)).name;
          if i < n-1 then
            result := result + separator;
        end;
    Except
      Exit;
    end;
    result := '';
  finally
    objShellApp := NULL;
    objFolder := NULL;
    objItems  := NULL;
  end;
end;

function WZIP_ExtractOneFile(DestDir, ZipFile, FileInZIP : string) : boolean;
var
  objShellApp, objFolder, objItem : variant;
begin
  result := false;
  if not DirectoryExists(DestDir) then Exit;
  try
    objShellApp := CreateOleObject('Shell.Application');
    objFolder :=  objShellApp.NameSpace((ZipFile));
    objItem := objFolder.ParseName(FileInZIP);
    try
      objShellApp.NameSpace((DestDir)).CopyHere(objItem, 20);
    Except
      Exit;
    end;
    result := True;
  finally
    objShellApp := NULL;
    objFolder := NULL;
    objItem  := NULL;
  end;
end;

function WZIP_ExtractAll(DestDir, ZipFile : string) : boolean;
var
  objShellApp, objFolder, objItem : variant;
begin
  if not DirectoryExists(DestDir) then Exit;
  try
    objShellApp := CreateOleObject('Shell.Application');
    objFolder :=  objShellApp.NameSpace((ZipFile));
    try
      objShellApp.NameSpace((DestDir)).CopyHere(objFolder.Items, 20);
    Except
      Exit;
    end;
    Sleep(1000);
    result := True;
  finally
    objShellApp := NULL;
    objFolder := NULL;
    objItem  := NULL;
  end;
end;

end.
