{++

v c e r t 1 . p a s

Translation of vcert1.h, converted by htrans 0.3.4
Copyright (c) 1997 Alexander Staubo, all rights reserved.

[Generated on 17-10-2002 at 18:15]
--}

unit vcert;
{$MINENUMSIZE 4}

interface

uses
  Windows, SysUtils;

type
  EVCERTApiMissingProcs = class(Exception);


type
  PPointer = ^Pointer;
  USHORT = Word;


{*
 * \file vcert1.h
 * API    API  
 *  ,    
 }

{* . }
type
  TErrorStatus = LongWord;
  TErrorStatuses = array [0..999999] of TErrorStatus;
  PErrorStatuses = ^TErrorStatuses;

{*     . }
type
  TContext = Pointer;
  TContexts = array [0..999999] of TContext;
  PContexts = ^TContexts;

{*  . }
type
  TCryptProv = (
    CRYPT_CRSRV,              {*< DCE RPC  }
    CRYPT_LOCAL,              {*<   }
    CRYPT_SOCKSRV,            {*< Socket  }
    CRYPT_LAST,
    CRYPT_PADDING = 388888888);{* four bytes padding *}

{* date in structures }
type
  date_t = Longword;
  flag_t = Longword;
  {$ifdef WIN32}
  size_t = Longword;
  {$endif}
  {$ifdef CPUX64}
  size_t = UInt64;
  {$endif}
  string_t = PAnsiChar;

{*  . }
type
  TMemBlk =  record
    len: Longword;             {*<   }
    buf: Pointer;              {*<  }
  end;
  PMemBlk = ^TMemBlk;

{*  . }
type
  TCertExtension = record
    OID : string_t;                  {*< OID,  . }
    CertType : Longword;             {*<  . }
    Critical : Longword;             {*<  . }
    Len : Longword;                  {*<    data. }
    Data : PAnsiChar;                {*< . }
  end;
  PCertExtension = ^TCertExtension;
  TCertExtensions = array [0..999999] of TCertExtension;
  PCertExtensions = ^TCertExtensions;

{*   . }
type
  TPolicy = record
    oid : string_t;                  {*< OID,  . }
    OrgName : string_t;              {*<  . }
    NotNum : Longword;
    Text : string_t;                 {*<     }
  end;
  PPolicy = ^TPolicy;
  PPolicies = ^TPolicies;
  TPolicies = array [0..999999] of TPolicy;

{*    . }
type
  TExtKeyUsage = record
    OID : string_t;                  {*< OID,  . }
  end;
  PExtKeyUsage = ^TExtKeyUsage;
  TExtKeyUsages = array [0..999999] of TExtKeyUsage;
  PExtKeyUsages = ^TExtKeyUsages;

{*  . }
type
  TAltName = record
    EmailAddress : string_t;         {*< rfc 822 email. }
    DNS : string_t;                  {*< dns . }
    URI : string_t;                  {*< URI . }
    IP : string_t;                   {*< IP . }
    OrganizationName : string_t;     {*<   (WIN1251). }
    RegistredAddress : string_t;     {*<   (WIN1251). }
    Surname : string_t;              {*< ..   (WIN1251). }
    BusinessCategory : string_t;     {*<  (WIN1251). }
    TelephoneNumber : string_t;      {*<  . }
    Description : string_t;          {*< . }
    AccountNumber : string_t;        {*<   . }
    BankId : string_t;               {*<   . }
    PhysicalDelivery : string_t;     {*<   (WIN1251). }
    ExchangeAddress : string_t;      {*< Exchange . }
    NotesAddress : string_t;         {*< Notes . }
  end;
  PAltName = ^TAltName;

{*    . }
type
  TKeyUsage = (
      KEYUSAGE_DIGITAL_SIGNATURE,     {*< . }
      KEYUSAGE_NON_REPUDATION,        {*<  }
      KEYUSAGE_KEY_ENCIPHERMENT,      {*<  . }
      KEYUSAGE_DATA_ENCIPHERMENT,     {*<  . }
      KEYUSAGE_KEY_AGREEMENT,         {*<    }
      KEYUSAGE_KEY_CERT_SIGN,         {*<  . }
      KEYUSAGE_CRL_SIGN,              {*<  . }
      KEYUSAGE_ENCIPHER_ONLY,
      KEYUSAGE_DECIPHER_ONLY
    );
  TKeyUsages = set of TKeyUsage;


{*     FIPS 186-2 RSA }
const
  ALGORITHM_RSA               = 'RSA';

{*       34.10-1994 }
const
  ALGORITHM_GOST_R_34_10_1994 = 'GOST R 34.10-1994';

{*       34.10-2001 }
const
  ALGORITHM_GOST_R_34_10_2001 = 'GOST R 34.10-2001';

{*     }

type
  TCertField =
    (FIELD_SERIAL,            {*     }
     FIELD_ISSUER,            {*    }
     FIELD_SUBJECT,           {*    }
     FIELD_ISSUERUID,
     FIELD_SUBJECTUID,
     FIELD_NOTBEFORE,         {*       }
     FIELD_NOTAFTER,          {*       }
     FIELD_KEYUSAGE,          {*       }
     FIELD_ISSUERALTNAME,     {*       }
     FIELD_SUBJECTALTNAME,    {*       }
     FIELD_EXTKEYUSAGE,       {*       }
     FIELD_POLICY,            {*      }
     FIELD_EXTENSIONS,        {*     }
     FIELD_NOTBEFOREPRIVATE,  {*         }
     FIELD_NOTAFTERPRIVATE,   {*         }
     FIELD_KEYID,             {*    ,   (     ) }
     FIELD_CERTENCODED,       {*   DER- }
     FIELD_CERTHASH,          {*   (     ) }
     FIELD_ALGORITHM);        {*   }

{*     ( ). }
  TCertInfo = set of TCertField;

{*    }
const
  FIELD_ALL = [FIELD_SERIAL, FIELD_ISSUER, FIELD_SUBJECT, FIELD_ISSUERUID,
               FIELD_SUBJECTUID, FIELD_NOTBEFORE, FIELD_NOTAFTER, FIELD_KEYUSAGE,
               FIELD_ISSUERALTNAME, FIELD_SUBJECTALTNAME, FIELD_EXTKEYUSAGE, FIELD_POLICY,
               FIELD_EXTENSIONS, FIELD_NOTBEFOREPRIVATE, FIELD_NOTAFTERPRIVATE, FIELD_KEYID,
               FIELD_CERTENCODED, FIELD_CERTHASH, FIELD_ALGORITHM];

{*  . }
type
  TCertificate = record
    Fields : TCertInfo;              {*<   (FIELD_XXX). }
    Issuer : string_t;               {*<  (   DN LDAP \0). }
    SerialNumber : string_t;         {*<    (  hex- \0). }
    Subject : string_t;              {*<  (   DN LDAP \0). }
    Algorithm: string_t;             {*<  . }
    NotBefore : date_t;              {*<     (time_t). }
    NotAfter : date_t;               {*<     (time_t). }
    IssuerUID : string_t;
    SubjectUID : string_t;
    KeyUsage : TKeyUsages;           {*<   (  KEYUSAGE_xxx). }
    NotBeforePrivate : date_t;       {*<      (time_t). }
    NotAfterPrivate : date_t;        {*<      (time_t). }
    IssuerAltName : TAltName;        {*<   . }
    SubjectAltName : TAltName;       {*<   . }
    KeyId : string_t;                {*<  ,  . }
    PolicyNum : Longword;            {*<   . }
    Policies : PPolicies;            {*<   . }
    ExtKeyUsageNum : Longword;       {*<    . }
    ExtKeyUsage : PExtKeyUsages;     {*<    . }
    ExtensionNum : Longword;         {*<  . }
    Extensions : PCertExtensions;    {*<  . }
    CertEncoded : TMemBlk;           {*<   DER-. }
    CertHash : TMemBlk;              {*<   }
  end;
  PCertificate = ^TCertificate;

{*  . }
  TRevCert = record
    SerialNumber: string_t;         {*<     (  hex- \0). }
    RevTime: date_t;                {*<    (time_t). }
    Reason: Longint;                {*<   . }
  end;
  PRevCert = ^TRevCert;
  TRevCerts = array [0..999999] of TRevCert;
  PRevCerts = ^TRevCerts;

type
  TCrlField =
    (FIELD_CRL_ISSUER,              {*    }
     FIELD_CRL_LASTUPDATE,          {*       }
     FIELD_CRL_NEXTUPDATE,          {*       }
     FIELD_CRL_NUMBER,              {*      }
     FIELD_CRL_REVOKED,             {*     }
     FIELD_CRL_CRLENCODED,          {*   DER- }
     FIELD_CRL_CRLHASH);            {*   (     ) }

{*     ( ). }
  TCrlInfo = set of TCrlField;

{*    }
const
  FIELD_CRL_ALL = [FIELD_CRL_ISSUER, FIELD_CRL_LASTUPDATE, FIELD_CRL_NEXTUPDATE,
                   FIELD_CRL_NUMBER, FIELD_CRL_REVOKED, FIELD_CRL_CRLENCODED,
                   FIELD_CRL_CRLHASH];

{*  . }
type
  TCrl = record
    Fields: TCrlInfo;               {*<   (FIELD_CRL_XXX). }
    Issuer: string_t;               {*<  (   DN LDAP \0). }
    LastUpdate: date_t;             {*<     (time_t). }
    NextUpdate: date_t;             {*<     (time_t). }
    Number: Longword;               {*<   . }
    RevCertNum: Longword;           {*<   . }
    RevCerts: PRevCerts;            {*<   . }
    CrlEncoded: TMemBlk;            {*<   DER-. }
    CrlHash: TMemBlk;               {*<  . }
  end;
  PCrl = ^TCrl;

{*   . }
type
  TIdChoice = (
    ID_ISSUER_AND_SERIAL,            {*<     . }
    ID_KEYID,                        {*<   . }
    ID_CERTHASH,                     {*<   . }
    ID_ALIAS,                        {*<   . }
  	ID_PADDING = 388888888
  );

{*     . }
type
  TIssuerAndSerial = record
    Issuer : string_t;               {*<  (   DN LDAP \0). }
    SerialNumber : string_t;         {*<    (  hex- \0). }
  end;

{*   . }
type
  PCertId = ^TCertId;
  TCertId = record
    ChoiceType : TIdChoice;          {*<   (ID_ISSUER_AND_SERIAL  ID_KEYID  ID_CERTHASH). }
    id :
      record
        case TIdChoice of
          ID_ISSUER_AND_SERIAL: (
              ias : TIssuerAndSerial;{*<     . }
            );
          ID_KEYID: (
              KeyId : string_t;      {*<  . }
            );
          ID_CERTHASH: (
              CertHash : TMemBlk;    {*<  . }
            );
          ID_ALIAS: (
              alias : string_t;      {*<   . }
            );
    end;
  end;

// do not convert following FLAG_XXX constants into enum,
// cos it may be mixed with FLAG_ENCRYPT_XXX const, etc
{*    }
const
  FLAG_SIMPLE = (0);

{*   PKCS#7 }
const
  FLAG_PKCS7 = (1 shl 0);

{*   detached  }
const
  FLAG_DETACHED = (1 shl 1);

{*       PKCS#7 }
const
  FLAG_SIGN_SENDCERT = (1 shl 3);

{*   . }
type
  TSignParams = record
    Flag: flag_t;            {*< (in)  ( FLAG_PKCS7, FLAG_DETACHED, FLAG_SIGN_XXX) }
    MyCert : PCertId;        {*< (in)       }
  end;
  PSignParams = ^TSignParams;

{*   . }

type
  TSignInfo = record
    Time : date_t;           {*<    }
    CertId : PCertId;        {*<  ,      }
  end;

{*   . }

type
  PSignStatus = ^TSignStatus;
  TSignStatus = record
    Status: TErrorStatus;    {*<    }
    Time: date_t;            {*<    }
    Cert: PCertificate;{*< ,      }
  end;

{*      }

const
  FLAG_VERIFY_DELSIGN = (1 shl 2);

{*     }

const
  FLAG_VERIFY_KEYUSAGE = (1 shl 3);

{*    }

const
  FLAG_VERIFY_POLICY = (1 shl 4);

{*    }
const
  FLAG_VERIFY_EXTKEYUSAGE = (1 shl 5);

{*     }
const
  FLAG_VERIFY_MINSIGNS = (1 shl 7);

{*     / }
const
  FLAG_VERIFY_NOTIMECHECK = (1 shl 10);

{*         }
const
  FLAG_VERIFY_NOCACHECERT = (1 shl 11);

{*      }
const
  FLAG_VERIFY_NOATTACHEDCERT = (1 shl 12);

{*          }
const
  FLAG_VERIFY_USEREVTIME = (1 shl 13);

{*     PKCS7    }
const
  FLAG_VERIFY_NOADDCER_FRM_PKCS7 = (1 shl 14);

{*    }
const
  DELETE_ALL_SIGNS = ( - 1);

{*   . }
type
  TVerifyParams = record
    Flag: flag_t;                    {*< (in)  ( FLAG_PKCS7, FLAG_DETACHED, FLAG_VERIFY_XXX) }
    MyCert: PCertId;                 {*< (in)     }
    KeyUsage: TKeyUsages;            {*<     }
    PolicyNum: Longword;             {*<   }
    Policies: ^TPolicy;              {*<   }
    ExtKeyUsageNum: Longword;        {*<    }
    ExtKeyUsage: ^TExtKeyUsage;      {*<    }
    ExtensionNum: Longword;          {*<   }
    Extensions: ^TCertExtension;     {*<   }
    nSignToDelete: Longint;          {*< DELETE_ALL_SIGNS    ,      0  PKCS7         }
    MinSigns: Longword;              {*<    }
    Info: TCertInfo;                 {*<    . }
  end;
  PVerifyParams = ^TVerifyParams;

{*    LDAP  (== FLAG_FIND_REMOTE) }
const
  FLAG_ENCRYPT_REMOTE = (1 shl 2);

{*         (   ) (== FLAG_FIND_SELECTUI) }
const
  FLAG_ENCRYPT_SELECTUI = (1 shl 3);

{*      (== FLAG_FIND_NOTIMECHECK) }
const
  FLAG_ENCRYPT_NOTIMECHECK = (1 shl 4);

{*     (== FLAG_FIND_NOVERIFY) }
const
  FLAG_ENCRYPT_NOVERIFY = (1 shl 5);

{*     LDAP    (== FLAG_FIND_ADD_LDAP2LOCAL) }
const
  FLAG_ENCRYPT_ADD_LDAP2LOCAL = (1 shl 7);

{*       (== FLAG_FIND_NOKEYTIMECHECK) }
const
  FLAG_ENCRYPT_NOKEYTIMECHECK  = (1 shl 8);
{*        (== FLAG_FIND_PARTIAL_SUBJECT) }
const
  FLAG_ENCRYPT_PARTIAL_SUBJECT = (1 shl 9);
{*       (== FLAG_FIND_IGNORE_CACHED) }
const
  FLAG_ENCRYPT_IGNORE_CACHED   = (1 shl 10);
{*       (== FLAG_FIND_IGNORE_LOCAL) }
const
  FLAG_ENCRYPT_IGNORE_LOCAL    = (1 shl 11);

{*  . }
type
  TEncryptParams = record
    Flag: flag_t;                   {*< (in)  ( FLAG_PKCS7, FLAG_ENCRYPT_XXX),        ) }
    MyCert: PCertId;                {*< (in)       }
    ReceiverNum: Longword;          {*<  . }
    Receivers: PCertificate;  {*<   . }
  end;
  PEncryptParams = ^TEncryptParams;

{*     }
const
  FLAG_DECRYPT_NOCACHE = (1 shl 1);
{*        }
const
  FLAG_DECRYPT_NOCRLCHECK = (1 shl 2);
{*     LDAP    (== FLAG_FIND_ADD_LDAP2LOCAL) }
const
  FLAG_DECRYPT_ADD_LDAP2LOCAL = (1 shl 7);

{*  . }
type
  TDecryptParams = record
    Flag: flag_t;             {*< (in)  ( FLAG_PKCS7) }
    MyCert: PCertId;          {*< (in)       }
    Info: TCertInfo;          {*<    . }
  end;
  PDecryptParams = ^TDecryptParams;

(*    *)
const
  FLAG_IMPORT_UI = ( 1 shl 0 );
(*    DER- *)
const
  FLAG_IMPORT_CERTIFICATE	= ( 1 shl 1 );
(*    DER- *)
const
  FLAG_IMPORT_CRL	= ( 1 shl 2 );
(*         *)
const
  FLAG_IMPORT_MY_CERTIFICATE =	( 1 shl 3 );
(*      *)
const
  FLAG_IMPORT_UPDATE =	( 1 shl 4 );
(*    PKCS#7 - -  
const
  FLAG_IMPORT_PKCS7	= ( 1 shl 5 );*)

(*  . *)
type
  TImportParams = record
    Flag: flag_t;     (*< (in)  ( FLAG_IMPORT_XXX) *)
    MyCert: PCertId;  (*< (in)       *)
  end;
  PImportParams = ^TImportParams;

(*    *)
const
  FLAG_EXPORT_UI =	( 1 shl 0 );
(*   ASN.1 (   PKCS#7) *)
const
  FLAG_EXPORT_ASN1 = ( 1 shl 1 );
(*      (  ) *)
const
  FLAG_EXPORT_NEWREQUEST =	( 1 shl 2 );
(*      *)
const
  FLAG_EXPORT_REVREQUEST =	( 1 shl 3 );
(*        *)
const
  FLAG_EXPORT_BACKUPKEY	= ( 1 shl 4 );

(*  . *)
type
  TExportParams = record
    Flag: flag_t;     (*< (in)  ( FLAG_EXPORT_XXX) *)
    MyCert: PCertId;  (*< (in)       *)
  end;
  PExportParams = ^TExportParams;

{*   . }
type
  TAddParams = record
    Flag: flag_t;          {*< (in)  (,   0) }
    MyCert: PCertId;       {*< (in)       }
  end;
  PAddParams = ^TAddParams;

{*   }
type
  TFindResult = record
    Num: Longword;               {*< (out)    }
    Certs: PCertificate;   {*< (out)    }
  end;

type
  TFindFlag =
    (FLAG_FIND_MY,          {*   ,      }
     FLAG_FIND_ALL,         {*    (deprecated -  ) }
     FLAG_FIND_REMOTE,      {*      }
     FLAG_FIND_SELECTUI,    {*         (   ) }
     FLAG_FIND_NOTIMECHECK, {*      }
     FLAG_FIND_NOVERIFY,    {*     }
     FLAG_FIND_NOCACHE,     {*    }
     FLAG_FIND_ADD_LDAP2LOCAL,{*     LDAP    }
     FLAG_FIND_NOKEYTIMECHECK,{*       }
     FLAG_FIND_PARTIAL_SUBJECT,{*        }
     FLAG_FIND_IGNORE_CACHED,{*       }
     FLAG_FIND_IGNORE_LOCAL {*       }
     );
  TFindFlags = set of TFindFlag;

{*   . }
type
  TFindParams = record
    Flag: TFindFlags;              {* <   ( FLAG_FIND_XXX)}
    MyCert: PCertId;               {*< (in)       }
    CertTemplate: TCertificate;    {*<    . }
    Info: TCertInfo;               {*<   (). }
  end;
  PFindParams = ^TFindParams;

{*   . }
type
  PSignStatuses = ^TSignStatuses;
  TSignStatuses = array [0..999999] of TSignStatus;
  PVerifyResult = ^TVerifyResult;
  TVerifyResult = record
    SignNum: Longword;                {*<  . }
    Signs: PSignStatuses;             {*<     . }
  end;

{*     . }
type
  PSignInfos = ^TSignInfos;
  TSignInfos = array [0..999999] of TSignInfo;
  PSignedInfoResult = ^TSignedInfoResult;
  TSignedInfoResult = record
    InfoType: flag_t;               {*<  . }
    SignNum: Longword;              {*<  . }
    Infos: PSignInfos;              {*<     . }
  end;

{*       }
const
  MAX_CONTAINER_COUNT = 4;

{*       }
type
  PCertIds = ^TCertIds;
  TCertIds = array [0..999999] of TCertId;
  PEncryptedInfoResult = ^TEncryptedInfoResult;
  TEncryptedInfoResult = record
    InfoType: flag_t;               {*<  . }
    recipients_num: Longword;       {*<  . }
    recipients: PCertIds;           {*<     . }
    sender: TCertId;                {*<    ( ). }
  end;
  TEncryptedInfoResults = array [0..MAX_CONTAINER_COUNT - 1] of TEncryptedInfoResult;

{*  . }
type
  PDecryptResult = ^TDecryptResult;
  TDecryptResult = record
//    Sender: TOpaqueCertificate;           {*<  . }
    Sender: TCertificate;           {*<  . }
  end;

{*     /   }
const
  FLAG_POLICY_NOTIMECHECK = ( 1 shl 2 );

{*  ,      }
const
  FLAG_POLICY_VERIFY_CRL     = (1 shl 5);

{*       }
const
  FLAG_POLICY_NOKEYTIMECHECK = (1 shl 6);

(**    (,    ). *)
type
  PVerifyPolicyParams = ^TVerifyPolicyParams;
  TVerifyPolicyParams = record
    size: Longword;         (**< (in)     *)
    flag: flag_t;           (**< (in)  ( FLAG_POLICY_XXX ) *)
    mycert: PCertId;        (**< (in)       *)
    check_time: date_t;     (**< (in) ,    .   ,   *)
    keyusage: TKeyUsages;   (**<      ( != 0,   ) *)
    eku_num: Longword;      (**<    ( >0    ) *)
    extkeyusages: PExtKeyUsages; (**<    *)
    policy_num: Longword;   (**<   ( >0    ) *)
    policies: PPolicies;    (**<   *)
  end;

{*    PKCS#7   }
const
  FLAG_PKCS7_INFO_TYPE_SIGNED = ( 1 shl 1 );

{*    PKCS#7   }
const
  FLAG_PKCS7_INFO_TYPE_ENVELOPED = ( 1 shl 2 );

{*    PKCS#7   ()  }
const
  FLAG_PKCS7_INFO_TYPE_DETACHED = ( 1 shl 3 );

type
{*        PKCS#7. }
  Tpkcs7_signer = record
    Digest: string_t;           (**< OID    *)
    Encryption: string_t;       (**< OID    *)
    Signer: TIssuerAndSerial;   (**<      *)
    AuthAttr_Num: Longword;     (**<    *)
    PAuthAttrs: string_t;       (**<  OID   *)
    UnAuthAttr_Num: Longword;   (**<     *)
    PUnAuthAttrs: string_t;     (**<  OID    *)
  end;
  Ppkcs7_signer = ^Tpkcs7_signer;
  Tpkcs7_signers = array [0..999999] of Tpkcs7_signer;
  Ppkcs7_signers = ^Tpkcs7_signers;

{*        PKCS#7. }
  Tpkcs7_recipient = record
    PublicKey: string_t;           (**< OID     *)
    Recipient: TIssuerAndSerial;   (**<      *)
  end;
  Ppkcs7_recipient = ^Tpkcs7_recipient;
  Tpkcs7_recipients = array [0..999999] of Tpkcs7_recipient;
  Ppkcs7_recipients = ^Tpkcs7_recipients;

{*        PKCS#7. }
  Ppkcs7_info = ^Tpkcs7_info;
  Tpkcs7_info = record
    Typ: Longword;                (**<     PKCS#7 ( FLAG_PKCS7_INFO_TYPE_XXX) *)
    Signer_Num: Longword;         (**<       PKCS#7 *)
    Signers: Ppkcs7_signers;      (**<       PKCS#7 *)
    DataCipher: string_t;         (**< OID     *)
    Recipient_Num: Longword;      (**<       PKCS#7 *)
    Recipients: Ppkcs7_recipients;(**<       PKCS#7 *)
  end;

(*   *)
type
 TcrsrvFunction = (
    CRSRV_FUNC_NO,
    CRSRV_FUNC_ENCRYPT,
    CRSRV_FUNC_DECRYPT,
    CRSRV_FUNC_SIGN, (*    *)
    CRSRV_FUNC_ADDCERT,
    CRSRV_FUNC_ADDCRL,
    CRSRV_FUNC_RESIGN, (*   *)
    CRSRV_FUNC_PADDING = 388888888 (* enum should be 4 bytes long *)
    );

(*
 *  online-  
 *)

(*   . *)
type
  TSessionKey = Pointer;

(*  . *)
type
  TConnection = Pointer;

{*      }

const
  CRYPT_MY = 'My';

{*     -   Windows. }
type
  TLocalParam = record
    Size: size_t;              {*<  ( ) ,   sizeof(TLocalParam). }
    Flag: flag_t;              {*<   (  FLAG_INIT_XXX) }
    pse : PAnsiChar;           {*<   ,  pse://signed/C:\WINNT\Profiles\Ivanov\PKI\local.pse. }
    LocalStore: PAnsiChar;     {*<   ,  file://C:\WINNT\Profiles\Ivanov\PKI\local.gdbm. }
    Ldap: PAnsiChar;           {*<   LDAP,  ldap://simple/ldap.x509.ru/cn=users,dc=x509,dc=ru. }
  end;
  PLocalParam = ^TLocalParam;

{      -   Windows }

{   } // cannot convert into enum cos of $F0000000 value
const
  FLAG_INIT_NOCRLUPDATE = 1 shl 0;   {*        }
const
  FLAG_INIT_CHECKEXPIRED = 1 shl 1;  {*         }
const
  FLAG_INIT_NOLDAP = 1 shl 2;        {*     }
const
  FLAG_INIT_NOKEYUNLOAD = 1 shl 3;   {*       (   -OW) }
(**         c    *)
const
  FLAG_INIT_CHECKEXPIRED_REQ = ( 1 shl 4 );
(**            *)
const
  FLAG_INIT_NOSAVECACHE = ( 1 shl 5 );
(**         pki1.conf
        VCERT_Initialize   (    "My")
        pki1.conf.        .
      FLAG_INIT_REGISTRY  ,     *)
const
  FLAG_INIT_REGISTRY = ( 1 shl 6 );
{*         }
const
  FLAG_INIT_FORCE_CACHE_CERTS = (1 shl 7);
{*             }
const
  FLAG_INIT_ALLOW_RA_IN_CHAIN = (1 shl 8);
{*              }
const
  FLAG_INIT_LDAP_CHAIN_SEARCH = (1 shl 9);
const
  FLAG_INIT_VERIFYCONTEXT = $80000000;{*       }

{*     DCE RPC . *}
type
  Pstring_t = ^string_t;
  TCrSrvParam = record
    Size: size_t;             {*<  ( ) ,   sizeof(TCrSrvParam). }
    Flag: flag_t;             {*<   (  0) }
    TimeOut: Longword;        {*< operation timeout (>= 0 && <= 10, default 5) }
    Num: Longword;            {*<     servers }
    Servers: Pstring_t;       {*<   (  <>:<>[<port>])  *}
  end;
  PCrSrvParam = ^TCrSrvParam;

(**     socket  . *)
type
  TSockSrvParam = record
    size: size_t;             (**<  ( ) ,   sizeof(socksrv_param_t). *)
    flag: flag_t;             (**<   (  0) *)
    timeout: Longword;        (**< operation timeout (> 0, default 5) *)
  	conn_timeout: Longword;   (**< connection timeout (> 0, default 5) *)
    alias: PAnsiChar;         (**<     *)
    username: PAnsiChar;      (**<   / *)
    password: PAnsiChar;      (**<   / *)
    num: Word;                (**<     servers *)
    servers: Pstring_t;       (**<   (  <>:<port>)  *)
  end;

(*  *)
const
  VCERT_CONN_GET_OTHERCERT        = 1;               //     (mem_blk_t*)value -   der-

  VCERT_OPT_ON  = Pointer(1);
  VCERT_OPT_OFF = Pointer(0);

(*   *)
const
  VCERT_CONN_CLIENT = ( 0 );
(*   *)
const
  VCERT_CONN_SERVER = ( 1 shl 0 );

(*  *)
const
  VCERT_CMD_PING            = 1;	                  (*     *)
  VCERT_CMD_UPDATECRLS      = 2;	                  (*        *)
  VCERT_CMD_SETAUTHDATA     = 3;	                  (*      *)
  VCERT_CMD_UPDATECRLSCRIT  = 4;                    (*  -      ,        *)
  VCERT_CMD_SET_TIMEOUT     = 5;                    (*  timeout  (mem_blk_t->data  long ) *)
  VCERT_CMD_GET_DEBUGTEXT   = 6;                    (*     sock-    *)
  VCERT_CMD_LAST            = VCERT_CMD_GET_DEBUGTEXT;

const
(**   *)
  VCERT_LOG_ERROR    = 3;
  VCERT_LOG_WARNING  = 4;
  VCERT_LOG_INFO     = 6;
  VCERT_LOG_DEBUG    = 7;

(*
 *          
 *   Base64.  Base64      6 
 *      2  .
 *         
 *  .
 *)
  function VCERT_BASE64_LEN(vlen: Integer): Integer;

{       vcerterr.h }
const
  P7SIGNED_EXTENSION                  = 'p7s';
  P7ENVELOPED_EXTENSION               = 'p7e';
  P7SIGNEDANDENVELOPED_EXTENSION      = 'p7a';
  P7SIGNED_EXTENSION_DOT              = '.p7s';
  P7ENVELOPED_EXTENSION_DOT           = '.p7e';
  P7SIGNEDANDENVELOPED_EXTENSION_DOT  = '.p7a';

//====== Dynamic loading support routines ==============================

type
  TDLLProc = function: Integer; stdcall;
  TDLLProcs = (
    fnAddCRL,
    fnAddCertificate,
    fnAllocMem,
    fnDecryptAndVerifyFile,
    fnDecryptAndVerifyMem,
    fnDecryptFile,
    fnDecryptMem,
    fnEncryptFile,
    fnEncryptMem,
    fnEncryptedInfoFile,
    fnEncryptedInfoMem,
    fnFindCert,
    fnFreeCert,
    fnFreeCertId,
    fnFreeDecryptResult,
    fnFreeEncryptedInfoResult,
    fnFreeFindResult,
    fnFreeMem,
    fnFreeSignedInfoResult,
    fnFreeVerifyResult,
    fnGenRandom,
    fnGetErrorText,
    fnHashFile,
    fnHashMem,
    fnInitialize,
    fnInitializeEx,
    fnMatch,
    fnParseCert,
    fnImportMem,
    fnImportFile,
    fnExportMem,
    fnExportFile,
    fnDetachSignMem,
    fnDetachSignFile,
    fnAttachSignMem,
    fnAttachSignFile,
    fnSetAuthData,
    fnShowCertificate,
    fnSignAndEncryptFile,
    fnSignAndEncryptMem,
    fnSignFile,
    fnSignMem,
    fnSignedInfoFile,
    fnSignedInfoMem,
    fnUninitialize,
    fnVerifyAndSignFile,
    fnVerifyAndSignMem,
    fnVerifyFile,
    fnVerifyMem,
    fnUpdateCRLs,
    fnVerifyCert,
    fnReallocMem,
    fnSignHashMem,
    fnVerifyHashMem,
    fnCopyCert,
    fnCtrl,
    fnCreateSession,
    fnFreeSession,
    fnSessionExport,
    fnSessionImport,
    fnSessionDerive,
    fnSessionEncrypt,
    fnSessionDecrypt,
    fnCreateConnection,
    fnFreeConnection,
    fnClientStep1,
    fnServerStep2,
    fnClientStep3,
    fnServerStep4,
    fnClientStep5,
    fnConnectionEncrypt,
    fnConnectionDecrypt,
    fnConnectionCtrl,
    fnEncodeMem,
    fnDecodeMem,
    fnDuplicateContext,
    fnVerifyCertificatePolicy,
    fnAuthorize,
    fnGetErrorLine,
    fnContainerEncryptMem,
    fnContainerDecryptMem,
    fnContainerEncryptedInfoMem,
    fnContainerEncryptFile,
    fnContainerDecryptFile,
    fnContainerEncryptedInfoFile,
    fnCheckExpiringCertKey,
    fnParseCrl,
    fnFreeCrl,
    fnVerifyCrlPolicy,
    fnShowCrl,
    fnGetPkcs7InfoMem,
    fnGetPkcs7InfoFile,
    fnFreePkcs7Info,
    fnStrSignFile,
    fnStrVerifyFile,
    fnStrEncryptFile,
    fnStrDecryptFile,
    fnStrEncryptedInfoFile
    );

  // VCERT functions prototypes

{*   
 * \retval 0   .
 * \retval -1  
 * \note         
 *    .    phCtx    
 *  VCERT_Uninitialize
 }
  TVCertInitializeProc = function
    (Profile: string_t;           {*< (in)   ("My"  NULL     ) }
     Flag: Longword;              {*< (in)   }
     out phCtx: TContext          {*< (out)    . }
    ): TErrorStatus; stdcall;

{*    
 * \retval = 0   .
 * \retval <> 0  
 * \note         
 *    .    \e phCtx    
 *  \e VCERT_Uninitialize
 }
  TVCertInitializeExProc = function
    (Prov: TCryptProv;            {*< (in)   (CRYPT_CRSRV  CRYPT_LOCAL) }
     Param: Pointer;              {*< (in)    (TCrSrvParam  TLocalParam) }
     out phCtx: TContext          {*< (out)    . }
    ): TErrorStatus; stdcall;

{*   .
 * \retval = 0   .
 * \retval <> 0   .
 * \note  ,    \e VCERT_Initialize.
 }
  TVCertUninitializeProc = function
    (hCtx: TContext               {*< (in) . }
    ): TErrorStatus; stdcall;

{*    .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertSignFileProc = function
    (hCtx: TContext;              {*< (in) . }
     SignPara: PSignParams;       {*< (in)   . }
     FileName: PAnsiChar;         {*< (in)     ,   detached . }
     SignFileName: PAnsiChar;     {*< (in)      (   ). }
     OutSignFileName: PAnsiChar   {*< (out)     . }
    ): TErrorStatus; stdcall;

{*   .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertFindCertProc = function
    (hCtx: TContext;              {*< (in) . }
     FindPara: PFindParams;       {*<   }
     out FindResult: TFindResult  {*<   }
    ): TErrorStatus; stdcall;


{*    (   )
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertShowCertificateProc = function
    (hCtx: TContext;              {*< (in) . }
     Cert: PMemBlk                {*< (in)      DER-. }
    ): TErrorStatus; stdcall;

{*    .
 * \note  ,   .
 }
  TVCertFreeFindResultProc = procedure
    (hCtx: TContext;              {*< (in) . }
     var FindResult: TFindResult  {*< (in)  . }
    ); stdcall;

{*   .
 * \note  ,   .
 }
  TVCertFreeCertProc = procedure
    (hCtx: TContext;              {*< (in) . }
     pCert: PCertificate    {*< (in)   . }
    ); stdcall;

{*   .
 * \note  ,       .
 }
  TVCertFreeMemProc = procedure
    (hCtx: TContext;              {*< (in) . }
     Data: Pointer                {*< (in)   . }
    ); stdcall;

{*     .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertParseCertProc = function
    (hCtx: TContext;              {*< (in) . }
     EncCert: PMemBlk;            {*< (in)      DER-. }
     Info: TCertInfo;             {*< (in)    . }
     Cert: PCertificate     {*< (out)  . }
    ): TErrorStatus; stdcall;

(*   /   
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertImportMemProc = function
    (hCtx: TContext;              (*< (in) . *)
     Par: PImportParams;          (*< (in)    *)
     InData: PMemBlk              (*< (in)    . *)
    ): TErrorStatus; stdcall;

(*   /  
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertImportFileProc = function
    (hCtx: TContext;              (*< (in) . *)
     Par: PImportParams;          (*< (in)    *)
     InFile: PAnsiChar            (*< (in)   . *)
    ): TErrorStatus; stdcall;

(*      
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertExportMemProc = function
    (hCtx: TContext;              (*< (in) . *)
     Par: PExportParams;          (*< (in)   *)
     OutData: PMemBlk             (*< (out)    . *)
    ): TErrorStatus; stdcall;

(*     
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertExportFileProc = function
    (hCtx: TContext;              (*< (in) . *)
     Par: PExportParams;          (*< (in)   *)
     OutFile: PAnsiChar           (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*       
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertDetachSignMemProc = function
    (hCtx: TContext;              (*< (in) . *)
     InData: PMemBlk;             (*< (in)    *)
     OutData: PMemBlk;            (*< (out)  *)
     Sign: PMemBlk                (*< (out)  *)
    ): TErrorStatus; stdcall;

(*      
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertDetachSignFileProc = function
    (hCtx: TContext;              (*< (in) . *)
     InFile: PAnsiChar;           (*< (in)    *)
     DataFile: PAnsiChar;         (*< (out)  *)
     SignFile: PAnsiChar          (*< (out)  *)
    ): TErrorStatus; stdcall;

(*       
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertAttachSignMemProc = function
    (hCtx: TContext;              (*< (in) . *)
     InData: PMemBlk;             (*< (in)  *)
     sign: PMemBlk;               (*< (in)  *)
     OutDate: PMemBlk             (*< (in)    *)
    ): TErrorStatus; stdcall;

(*      
 * \retval = 0   .
 * \retval <> 0   .
 *)
  TVCertAttachSignFileProc = function
    (hCtx: TContext;              (*< (in) . *)
     DataFile: PAnsiChar;         (*< (in)    *)
     SignFile: PAnsiChar;         (*< (in)    *)
     OutFile: PAnsiChar           (*< (in)     *)
    ): TErrorStatus; stdcall;

{*   .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertEncryptFileProc = function
    (hCtx: TContext;              {*< (in) . }
     EncryptPara: PEncryptParams; {*< (in)   . }
     InFileName: PAnsiChar;       {*< (in)  . }
     OutFileName: PAnsiChar       {*< (out)  . }
    ): TErrorStatus; stdcall;

{*      .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertSignAndEncryptFileProc = function
    (hCtx: TContext;
     pSignPara: PSignParams;
     pEncryptPara: PEncryptParams;
     inFile: PAnsiChar;
     outFile: PAnsiChar
    ): TErrorStatus; stdcall;

{*   .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertDecryptFileProc = function
    (hCtx: TContext;              {*< (in) . }
     DecryptPara: PDecryptParams; {*< (in)   . }
     FileName: PAnsiChar;         {*< (in)  . }
     OutFileName: PAnsiChar;      {*< (out)  . }
     out DecryptResult: TDecryptResult  {*< (out)  . }
    ): TErrorStatus; stdcall;

{*   .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertHashFileProc = function
    (hCtx: TContext;              {*< (in) . }
     FileName: PAnsiChar;         {*< (in)    . }
     out Hash: TMemBlk            {*< (out)    -   . }
    ): TErrorStatus; stdcall;

{*    .
 * \note  ,   .
 }
  TVCertFreeDecryptResultProc = procedure
    (hCtx: TContext;              {*< (in) . }
     var DecryptResult: TDecryptResult  {*< (in)  . }
    ); stdcall;

{*    .
 * \retval = 0   .
 * \retval <> 0 .
 }
  TVCertVerifyFileProc = function
    (hCtx: TContext;              {*< (in) . }
     VerifyPara: PVerifyParams;   {*< (in)   . }
     FileName,                    {*< (in)     ,   detached . }
     SignFileName,                {*< (in)      (   ). }
     OutSignFileName: PAnsiChar;  {*< (out)     . }
     out VerifyResult: TVerifyResult  {*< (out)   . }
    ) : TErrorStatus; stdcall;

{*    .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertGenRandomProc = function
    (hCtx: TContext;              {*< (in) . }
     len: Longword;               {*< (in)  . }
     var Random: TMemBlk          {*< (out) . }
    ): TErrorStatus; stdcall;

{*     .
 * \return      
 }
  TVCertGetErrorTextProc = function
    (Error: TErrorStatus;
     Mes: PAnsiChar;
     Len: size_t
    ): PAnsiChar; stdcall;

{*      .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertSignedInfoFileProc = function
    (hCtx: TContext;              {*< (in) . }
     SignFileName: PAnsiChar;     {*< (in)     . }
     out SignInfo: TSignedInfoResult  {*< (out)   . }
    ): TErrorStatus; stdcall;

{*      .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertEncryptedInfoFileProc = function
    (hCtx: TContext;              {*< (in) . }
     pEncrypted: PAnsiChar;       {*< (in)   . }
     out EncryptedInfo: TEncryptedInfoResult  {*< (out)    . }
    ): TErrorStatus; stdcall;

{*      .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertDecryptAndVerifyFileProc = function
    (hCtx : TContext;
     pDecryptPara : PDecryptParams;
     pVerifyPara : PVerifyParams;
     inFile : PAnsiChar;
     outFile : PAnsiChar;
     out DecryptResult : TDecryptResult;
     out VerifyResult : TVerifyResult
    ) : TErrorStatus; stdcall;

{*         .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertVerifyAndSignFileProc = function
    (hCtx : TContext;             {*< (in) . }
     pVerifyPara : PVerifyParams; {*< (in)   . }
     pSignPara : PSignParams;     {*< (in)   . }
     data : PAnsiChar;            {*< (in)     ,   detached . }
     sign_in : PAnsiChar;         {*< (in)     . }
     sign_out : PAnsiChar;        {*< (out)     . }
     out VerifyResult : TVerifyResult {*< (out)   . }
    ) : TErrorStatus; stdcall;


{*     .
 * \note     (  X.500 ).
 * \retval 0    .
 * \retval 1    .
 }
  TVCertMatchProc = function
    (Pattern: string_t;           {*< (in) . }
     TestString: string_t         {*< (in)   . }
    ): LongBool; stdcall;

{*     .
 * \note  ,      .
 }
  TVCertFreeSignedInfoResultProc = procedure
    (hCtx: TContext;              {*< (in) . }
     pSignInfo : PSignedInfoResult{*< (in)   . }
    ); stdcall;

{*      .
 * \note  ,       .
 }
  TVCertFreeEncryptedInfoResultProc = procedure
    (hctx: TContext;              {*< (in) . }
     pEncryptInfo: PEncryptedInfoResult {*< (in)   . }
    ); stdcall;

{*    .
 * \note    .
 }
  TVCertAllocMemProc = function
    (hCtx: TContext;              {*< (in) . }
     Len : Longword               {*< (in)  . }
    ): Pointer; stdcall;

{*    .
 * \retval = 0   .
 * \retval <>    .
 }
  TVCertHashMemProc = function
    (hCtx: TContext;              {*< (in) . }
     InData: PMemBlk;             {*< (in)   ,    . }
     out hash: TMemBlk            {*< (out)    -   . }
    ): TErrorStatus; stdcall;

{*     .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertSignMemProc = function
    (hCtx : TContext;             {*< (in) . }
     SignPara: PSignParams;       {*< (in)   . }
     Data: PMemBlk;               {*< (in)   ,   detached . }
     SignIn: PMemBlk;             {*< (in)    (   ). }
     var SignOut : TMemBlk        {*< (out)   . }
    ): TErrorStatus; stdcall;

{*     .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertVerifyMemProc = function
    (hCtx: TContext;              {*< (in) . }
     VerifyPara: PVerifyParams;   {*< (in)   . }
     Data: PMemBlk;               {*< (in)   ,   detached . }
     SignIn: PMemBlk;             {*< (in)    (   ). }
     SignOut: PMemBlk;            {*< (out)   . }
     out VerifyResult: TVerifyResult
    ): TErrorStatus; stdcall;

{*  .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertEncryptMemProc = function
    (hCtx: TContext;              {*< (in) . }
     EncryptPara: PEncryptParams; {*< (in)   . }
     DataIn: PMemBlk;             {*< (in)   ,    . }
     var DataOut: TMemBlk         {*< (out)   ,    . }
    ): TErrorStatus; stdcall;

{*    .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertDecryptMemProc = function
    (hCtx: TContext;              {*< (in) . }
     DecryptPara: PDecryptParams; {*< (in)  . }
     DataIn: PMemBlk;             {*< (in)   ,    . }
     var DataOut: TMemBlk;        {*< (out)   ,    . }
     out DecryptResult: TDecryptResult  {*< (out)  . }
    ): TErrorStatus; stdcall;


{*       .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertSignAndEncryptMemProc = function
    (hCtx: TContext;              {*< (in) . }
     SignPara: PSignParams;       {*< (in)   . }
     EncryptPara: PEncryptParams; {*< (in)   . }
     DataIn: PMemBlk;             {*< (in)   ,    . }
     var DataOut: TMemBlk         {*< (out)   ,    . }
    ): TErrorStatus; stdcall;

{*        .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertDecryptAndVerifyMemProc = function
    (hCtx: TContext;              {*< (in) . }
     DecryptPara: PDecryptParams; {*< (in)   . }
     VerifyPara: PVerifyParams;   {*< (in)    }
     DataIn: PMemBlk;             {*< (in)   ,    . }
     out DataOut: TMemBlk;        {*< (out)   ,    . }
     out DecryptResult: TDecryptResult; {*< (out)  .}
     out VerifyResult: TVerifyResult    {*< (out)   . }
    ): TErrorStatus; stdcall;

{*          .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertVerifyAndSignMemProc = function
    (hCtx: TContext;              {*< (in) . }
     VerifyPara: PVerifyParams;   {*< (in)   . }
     SignPara: PSignParams;       {*< (in)   . }
     Data: PMemBlk;               {*< (in)     ,   detached . }
     SignIn: PMemBlk;             {*< (in)     . }
     var SignOut: TMemBlk;        {*< (out)     . }
     out VerifyResult: TVerifyResult  {*< (out)   . }
    ): TErrorStatus; stdcall;

{*     .
 * \note  ,    .
 }
  TVCertFreeVerifyResultProc = procedure
    (hCtx: TContext;              {*< (in) . }
     VerifyResult: PVerifyResult  {*< (in)   . }
    ); stdcall;

{*    .
 * \note  ,    .
 }
  TVCertFreeCertIdProc = procedure
    (hCtx: TContext;              {*< (in) . }
     CertId: PCertId              {*< (in)   . }
    ); stdcall;

{*   .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertAddCertificateProc = function
    (hCtx: TContext;              {*< (in) . }
     AddParam: PAddParams;        {*< (in)    }
     Cert: PMemBlk                {*< (in)      DER-. }
    ): TErrorStatus; stdcall;

{*   COC.
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertAddCRLProc = function
    (hCtx: TContext;              {*< (in) . }
     AddParam: PAddParams;        {*< (in)    }
     CRL: PMemBlk                 {*< (in)      DER-. }
    ): TErrorStatus; stdcall;

{*       .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertEncryptedInfoMemProc = function
    (hCtx: TContext;              {*< (in) . }
     pEncrypted: PMemBlk;         {*< (in)  . }
     out EncryptedInfo: TEncryptedInfoResult  {*< (out)    . }
    ): TErrorStatus; stdcall;

{*    
 * \retval = 0   .
 * \retval <> 0  
 }
  TVCertSetAuthDataProc = function
    (hCtx: TContext;              {*< (in) . }
     auth: PMemBlk                {*< (in)  . }
    ): TErrorStatus; stdcall;

{*       .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertSignedInfoMemProc = function
    (hCtx: TContext;              {*< (in) . }
     sign: PMemBlk;               {*< (in)   . }
     out SignInfo: TSignedInfoResult  {*< (out)   . }
    ): TErrorStatus; stdcall;

{*    (   )
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertUpdateCRLsProc = function (hCtx: TContext): TErrorStatus; stdcall;

{*      .
 * \note      
 * \note   VCERT_VerifyCertificatePolicy
 }
  TVCertVerifyCertProc = function
    (hCtx: TContext;              {*< (in) . }
     pVerifyPara: PVerifyParams;  {*< (in)  . }
     enccert: PMemBlk;            {*< (in)      DER-. }
     cert: PCertificate     {*< (out, optional)  . }
    ): TErrorStatus; stdcall;

{*      
 * \retval    |   .
 }
  TVCertDuplicateContextProc = function
    (hCtx : TContext              (**< (in) . *)
    ): TContext; stdcall;

(*    .
 * \note    .
 *)
  TVCertReallocMemProc = function
    (hCtx: TContext;              (*< (in) . *)
     data: Pointer;               (*< (in)   . *)
     len: Longword                (*< (in)  . *)
    ): Pointer; stdcall;

(*     
 *)
  TVCertSignHashMemProc = function
    (hCtx: TContext;              (*< (in) . *)
     mycert: PCertId;             (*< (in)    (  ). *)
     hash: PMemBlk;               (*< (in)    . *)
     sign: PMemBlk                (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*     
 *)
  TVCertVerifyHashMemProc = function
    (hCtx: TContext;              (*< (in) . *)
     mycert: PCertId;             (*< (in)    (  ). *)
     sender: PmemBlk;             (*< (in)   DER-   *)
     hash: PMemBlk;               (*< (in)    . *)
     sign: PMemBlk                (*< (in)   . *)
    ): TErrorStatus; stdcall;

(*     .
 * \note    .
 *)
  TVCertCopyCertProc = function
    (hCtx: TContext;              (*< (in) . *)
     inCert: PCertificate;  (*< (in)   . *)
     outCert: PCertificate  (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*    
 *)
  TVCertCtrlProc = function
    (hCtx: TContext;              (*< (in) . *)
     cmd: Longint;                (*< (in)  (VCERT_CMD_XXX). *)
     data: PMemBlk                (*< (in,out,optional)  *)
    ): TErrorStatus; stdcall;

(*
 *       online-  
 *)

(*
 *    .
 * \return 0      .
 *)
  TVCertCreateSessionProc = function
    (hCtx: TContext;              (*< (in) . *)
     out hSessionKey: TSessionKey (*< (out)  . *)
    ): TErrorStatus; stdcall;

(*
 *    .
 * \return 0      .
 *)
  TVCertFreeSessionProc = procedure
    (hCtx: TContext;              (*< (in) . *)
     hSessionKey: TSessionKey     (*< (in)  . *)
    ); stdcall;

(*
 *     .
 * \note         
 *  .
 * \return 0      .
 *)
  TVCertSessionExportProc = function
    (hCtx: TContext;              (*< (in) . *)
     hSessionKey: TSessionKey;    (*< (in)  . *)
     binkey: PmemBlk              (*< (out)     . *)
    ): TErrorStatus; stdcall;

(*
 *    .
 * \note        
 *   .
 * \return 0      .
 *)
  TVCertSessionImportProc = function
    (hCtx: TContext;              (*< (in) . *)
     binkey: PMemBlk;             (*< (in)     . *)
     out hSessionKey: TSessionKey (*< (out)  . *)
    ): TErrorStatus; stdcall;

(*
 *     
 * \return 0      .
 *)
  TVCertSessionDeriveProc = function
    (hCtx: TContext;              (*< (in) . *)
     hSession1: TSessionKey;      (*< (in)   . *)
     hSession2: TSessionKey;      (*< (in)   . *)
     out hSessionOut: TSessionKey (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*
 *     .
 * \return 0      .
 *)
  TVCertSessionEncryptProc = function
    (hCtx: TContext;              (*< (in) . *)
     hSessionKey: TSessionKey;    (*< (in)  . *)
     inData: PMemBlk;             (*< (in) . *)
     authrnd: PMemBlk;            (*< (in)    . *)
     outData: PMemBlk             (*< (out)  . *)
    ): TErrorStatus; stdcall;

(*
 *     .
 * \return 0      .
 *)
  TVCertSessionDecryptProc = function
    (hCtx: TContext;              (*< (in) . *)
     hSessionKey: TSessionKey;    (*< (in)  . *)
     inData: PMemBlk;             (*< (in)  . *)
     authrnd: PMemBlk;            (*< (in)    . *)
     outData: PMemBlk             (*< (out)  . *)
    ): TErrorStatus; stdcall;

(*
 *  online-  
 *)

(*                       

                                           

   CreateClient    |                      |    CreateServer
                   |                      |
   ClientStep1     |                      |
                    --- 1--->----
                   |                      |    ServerStep2
                    ----<--- 2---
   ClientStep3     |                      |
                    --- 3--->----
                   |                      |    ServerStep4
                   |                      |   ( )
                    ----<--- 4---
   ClientStep5     |                      |
  ( )   |                      |
                   |
   ConnEncrypt/     --<--    |   ConnEncrypt/
   ConnDecrypt     |      -->----    ConnDecrypt
                   |                      |
   FreeConnection  |                      |   FreeConnection

*)

(*
 *   .
 * \return 0      .
 *)
  TVCertCreateConnectionProc = function
    (hCtx: TContext;              (*< (in) . *)
     server: Integer;             (*< (in)  / (VCERT_CONN_CLIENT/VCERT_CONN_SERVER) *)
     out hConn: TConnection       (*< (out) . *)
    ): TErrorStatus; stdcall;

(*
 *   .
 * \note          
 * \return 0      .
 *)
  TVCertFreeConnectionProc = procedure
    (hCtx: TContext;              (*< (in) . *)
     hConn: TConnection           (*< (in) . *)
    ); stdcall;

(*
 *     .
 * \return 0      .
 *)
  TVCertClientStep1Proc = function
    (hCtx: TContext;              (*< (in) . *)
     hClientConn: TConnection;    (*< (in/out)  . *)
     pServerCert: PCertificate; (*< (in) /  . *)
     msg1: PMemBlk                (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*
 *          .
 * \return 0      .
 *)
  TVCertServerStep2Proc = function
    (hCtx: TContext;              (*< (in) . *)
     hServerConn: TConnection;    (*< (in/out)  . *)
     msg1: PMemBlk;               (*< (in)   . *)
     msg2: PMemBlk                (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*
 *          .
 * \return 0      .
 *)
  TVCertClientStep3Proc = function
    (hCtx: TContext;              (*< (in) . *)
     hClientConn: TConnection;    (*< (in/out)  . *)
     msg2: PMemBlk;               (*< (in)   . *)
     msg3: PmemBlk                (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*
 *          .
 * \note       .
 * \return 0      .
 *)
  TVCertServerStep4Proc = function
    (hCtx: TContext;              (*< (in) . *)
     hServerConn: TConnection;    (*< (in/out)   (). *)
     msg3: PMemBlk;               (*< (in)   . *)
     msg4: PmemBlk                (*< (out)   . *)
    ): TErrorStatus; stdcall;

(*
 *     .
 * \note       .
 * \return 0      .
 *)
  TVCertClientStep5Proc = function
   (hCtx: TContext;               (*< (in) . *)
    hClientConn: TConnection;     (*< (in/out)   (). *)
    msg4: PMemBlk                 (*< (in)   . *)
   ): TErrorStatus; stdcall;

(*
 *   .
 * \return 0      .
 *)
  TVCertConnectionEncryptProc = function
    (hCtx: TContext;              (*< (in) . *)
     hConn: TConnection;          (*< (in/out)  . *)
     inData: PMemBlk;             (*< (in)  . *)
     outData: PMemBlk             (*< (out)  . *)
    ): TErrorStatus; stdcall;

(*
 *   .
 * \return 0      .
 *)
  TVCertConnectionDecryptProc = function
    (hCtx: TContext;              (*< (in) . *)
     hConn: TConnection;          (*< (in/out)  . *)
     inData: PMemBlk;             (*< (in)  . *)
     outData: PmemBlk             (*< (out)  . *)
    ): TErrorStatus; stdcall;

(*   /  
 *)
  TVCertConnectionCtrlProc = function
    (hCtx: TContext;              (*< (in) . *)
     hConn: TConnection;          (*< (in/out)  . *)
     cmd: Longint;                (*< (in)  (VCERT_CONN_XXX). *)
     value: Pointer               (*< (in,out,optional)  *)
    ): TErrorStatus; stdcall;

(*     Base64
 * \retval      Base64.
 *)
  TVCertEncodeMemProc = function
    (t: PByte;                    (*< (out)     (   VCERT_BASE64_LEN). *)
     f: PByte;                    (*< (in)      . *)
     n: Longword                  (*< (in)     . *)
    ): Longword; stdcall;

(*     Base64
 * \retval      .
 *)
  TVCertDecodeMemProc = function
    (t: PByte;                    (*< (out)     . *)
     f: PByte;                    (*< (in)      Base64. *)
     n: Longword                  (*< (in)       Base64. *)
    ): Longword; stdcall;

{**   ,  ,     .
 * \note        
 *}
  TVCertVerifyCertificatePolicyProc = function
    (hCtx: TContext;              {*< (in) . }
     pPolicyPara: PVerifyPolicyParams;  {**< (in)  . *}
     certificate: PMemBlk         {**< (in)    . *}
    ): TErrorStatus; stdcall;

(**        
 * \retval = 0         .
 * \retval <> 0   .
 *)
  TVCertAuthorizeProc = function
    (hCtx: TContext;              (**< (in) . *)
     mycert: PCertId;             (**< (in)    (  ). *)
     func: TCrsrvFunction;        (**< (in)    *)
     auth: PMemBlk                (**< (in)   *)
    ): TErrorStatus; stdcall;

(**      PKI
 * \retval = 0      error, file, line  data.
 * \retval <> 0   .
 *)
  TVCertGetErrorLineProc = function
    (hCtx: TContext;              (**< (in) . *)
     out error: TMemBlk;          (**< (out)  . *)
     out _file: TMemBlk;          (**< (out)  . *)
     out line: Longword           (**< (out)  . *)
    ): TErrorStatus; stdcall;

(**     .
 * \retval >=0    -    .
 * \retval VCERT_E_INVALID_PARAMETER  -   .
 * \retval VCERT_E_NO_MEMORY  -  .
 *)
  TVCertContainerEncryptMemProc = function
    (hCtx: PContexts;             (**< (in)   (  - NULL). *)
     pEncryptPara: PEncryptParams;(**< (in)   . *)
     _in: PMemBlk;                (**< (in)   ,    . *)
     out _out: TMemBlk;           (**< (out)   ,     (    ). *)
     status: PErrorStatuses       (**< (out)    (  NULL)  . *)
    ): Longword; stdcall;

(**     .
 * \retval >=0    -    .
 * \retval VCERT_E_INVALID_PARAMETER  -  .
 *)
  TVCertContainerDecryptMemProc = function
    (hCtx: PContexts;             (**< (in)   (  - NULL). *)
     pDecryptPara: PDecryptParams;(**< (in)   . *)
     _in: PMemBlk;                (**< (in)   ,    . *)
     out _out: TMemBlk;           (**< (out)   ,     (    ). *)
     out pDecryptResult: TDecryptResult;  (**< (out)  . *)
     status: PErrorStatuses       (**< (out)    (  NULL)  . *)
    ): Longword; stdcall;

(**        .
 * \retval >0    -     ( 1,  4).
 * \retval VCERT_E_INVALID_PARAMETER  -  .
 *)
  TVCertContainerEncryptedInfoMemProc = function
    (hCtx: TContext;              (**< (in) . *)
     _in: PMemBlk;                (**< (in)   ,    . *)
     out pEncryptedInfo: TEncryptedInfoResults; (**< (out)      (    4 ). *)
     status: PErrorStatuses       (**< (out)    (  NULL)   (    4 ). *)
    ): Longword; stdcall;

(**    .
 * \retval >=0    -    .
 * \retval VCERT_E_INVALID_PARAMETER  -   .
 * \retval VCERT_E_NO_MEMORY  -  .
 * \retval VCERT_E_XXXFILEXXX  -    .
 *)
  TVCertContainerEncryptFileProc = function
    (hCtx: PContexts;             (**< (in)   (  - NULL). *)
     pEncryptPara: PEncryptParams;(**< (in)   . *)
     _in: PAnsiChar;              (**< (in)      . *)
     _out: PAnsiChar;             (**< (out)      . *)
     status: PErrorStatuses       (**< (out)    (  NULL)  . *)
    ): Longword; stdcall;

(**    .
 * \retval >=0    -    .
 * \retval VCERT_E_INVALID_PARAMETER  -  .
 * \retval VCERT_E_XXXFILEXXX  -    .
 *)
  TVCertContainerDecryptFileProc = function
    (hCtx: PContexts;             (**< (in)   (  - NULL). *)
     pDecryptPara: PDecryptParams;(**< (in)   . *)
     _in: PAnsiChar;              (**< (in)      . *)
     _out: PAnsiChar;             (**< (out)      . *)
     out pDecryptResult: TDecryptResult;  (**< (out)  . *)
     status: PErrorStatuses       (**< (out)    (  NULL)  . *)
    ): Longword; stdcall;

(**       .
 * \retval >0    -     ( 1,  4).
 * \retval VCERT_E_INVALID_PARAMETER  -  .
 *)
  TVCertContainerEncryptedInfoFileProc = function
    (hCtx: TContext;              (**< (in) . *)
     _in: PAnsiChar;              (**< (in)      . *)
     out pEncryptedInfo: TEncryptedInfoResults; (**< (out)      (    4 ). *)
     status: PErrorStatuses       (**< (out)    (  NULL)   (    4 ). *)
    ): Longword; stdcall;

(**           nDay
 * \retval  0   .
 * \retval VCERT_E_GENERIC    .
 *)
  TVCertCheckExpiringCertKeyProc = function
    (hCtx: TContext;              (**< (in) . *)
     var Days: Longword;          (**< (in/out)          .    . *)
     KeyId: string_t              (**< (out)    . *)
    ): TErrorStatus; stdcall;

{*     .
 * \retval = 0   .
 * \retval <> 0   .
 }
  TVCertParseCrlProc = function
    (hCtx: TContext;              {*< (in) . }
     EncCrl: PMemBlk;             {*< (in)      DER-. }
     Info: TCrlInfo;              {*< (in)    . }
     out Crl: TCrl                {*< (out)  . }
    ): TErrorStatus; stdcall;

{*   .
 * \note  ,   .
 }
  TVCertFreeCrlProc = procedure
    (hCtx: TContext;              {*< (in) . }
     pCrl: PCrl                   {*< (in)   . }
    ); stdcall;

{*   ,     .
 * \note       .
 }
  TVCertVerifyCrlPolicyProc = function
    (hCtx: TContext;              {*< (in) . }
     pPolicyPara: PVerifyPolicyParams;  {*< (in)  . }
     crl: PMemBlk                 {*< (in)    . }
    ): TErrorStatus; stdcall;

{*    (   ).
 * \retval == 0   .
 * \retval != 0   .
 }
  TVCertShowCrlProc = function
    (hCtx: TContext;              {*< (in) . }
     crl: PMemBlk                 {*< (in)      DER-. }
    ): TErrorStatus; stdcall;

{*         PKCS#7.
 * \retval == 0   .
 * \retval != 0   .
 }
  TVCertGetPkcs7InfoMemProc = function
    (hCtx: TContext;              {*< (in) . }
     pkcs7: PMemBlk;              {*< (in)     PKCS#7. }
     pPkcs7Info: Ppkcs7_info      {*< (out)   . }
    ): TErrorStatus; stdcall;

{*        PKCS#7.
 * \retval == 0   .
 * \retval != 0   .
 }
  TVCertGetPkcs7InfoFileProc = function
    (hCtx: TContext;              {*< (in) . }
     pkcs7: PAnsiChar;            {*< (in)    PKCS#7. }
     pPkcs7Info: Ppkcs7_info      {*< (out)   . }
    ): TErrorStatus; stdcall;

{*        PKCS#7.
 * \note  ,         PKCS#7.
 }
  TVCertFreePkcs7InfoProc = procedure
    (hCtx: TContext;              {*< (in) . }
     pPkcs7Info: Ppkcs7_info      {*< (in)      PKCS#7. }
    ); stdcall;

{*    .
 * \retval == 0   .
 * \retval != 0   .
 *}
  TVCertStrEncryptFileProc = function
    (hCtx: TContext;              {*< (in) . *}
     EncryptPara: PEncryptParams; {*< (in)   . }
     InFileName: PAnsiChar;       {*< (in)  . }
     OutFileName: PAnsiChar       {*< (out)  . }
  ): TErrorStatus; stdcall;

{*    .
 * \retval == 0   .
 * \retval != 0   .
 *}
  TVCertStrDecryptFileProc = function
    (hCtx: TContext;              {*< (in) . }
     DecryptPara: PDecryptParams; {*< (in)   . }
     FileName: PAnsiChar;         {*< (in)  . }
     OutFileName: PAnsiChar;      {*< (out)  . }
     out DecryptResult: TDecryptResult  {*< (out)  . }
    ): TErrorStatus; stdcall;

{*       .
 * \retval == 0   .
 * \retval != 0   .
 *}
  TVCertStrEncryptedInfoFileProc = function
    (hCtx: TContext;                          {*< (in) . }
     pEncrypted: PAnsiChar;                   {*< (in)   . }
     out EncryptedInfo: TEncryptedInfoResult  {*< (out)    . }
    ): TErrorStatus; stdcall;

{*     .
 * \retval == 0   .
 * \retval != 0   .
 *}
  TVCertStrSignFileProc = function
    (hCtx: TContext;              {*< (in) . }
     SignPara: PSignParams;       {*< (in)   . }
     FileName: PAnsiChar;         {*< (in)     ,   detached . }
     SignFileName: PAnsiChar;     {*< (in)      (   ). }
     OutSignFileName: PAnsiChar   {*< (out)     . }
    ): TErrorStatus; stdcall;

{*     .
 * \retval == 0   .
 * \retval != 0   .
 *}
  TVCertStrVerifyFileProc = function
    (hCtx: TContext;              {*< (in) . }
     VerifyPara: PVerifyParams;   {*< (in)   . }
     FileName,                    {*< (in)     ,   detached . }
     SignFileName,                {*< (in)      (   ). }
     OutSignFileName: PAnsiChar;  {*< (out)     . }
     out VerifyResult: TVerifyResult  {*< (out)   . }
    ) : TErrorStatus; stdcall;

type
  TVCERTApi = class
  private
    fDllHandle: HMODULE;
    //    xPKI1.DLL -       TDLLProcs
    fAddCRL: TVCertAddCRLProc;
    fAddCertificate: TVCertAddCertificateProc;
    fAllocMem: TVCertAllocMemProc;
    fDecryptAndVerifyFile: TVCertDecryptAndVerifyFileProc;
    fDecryptAndVerifyMem: TVCertDecryptAndVerifyMemProc;
    fDecryptFile: TVCertDecryptFileProc;
    fDecryptMem: TVCertDecryptMemProc;
    fEncryptFile: TVCertEncryptFileProc;
    fEncryptMem: TVCertEncryptMemProc;
    fEncryptedInfoFile: TVCertEncryptedInfoFileProc;
    fEncryptedInfoMem: TVCertEncryptedInfoMemProc;
    fFindCert: TVCertFindCertProc;
    fFreeCert: TVCertFreeCertProc;
    fFreeCertId: TVCertFreeCertIdProc;
    fFreeDecryptResult: TVCertFreeDecryptResultProc;
    fFreeEncryptedInfoResult: TVCertFreeEncryptedInfoResultProc;
    fFreeFindResult: TVCertFreeFindResultProc;
    fFreeMem: TVCertFreeMemProc;
    fFreeSignedInfoResult: TVCertFreeSignedInfoResultProc;
    fFreeVerifyResult: TVCertFreeVerifyResultProc;
    fGenRandom: TVCertGenRandomProc;
    fGetErrorText: TVCertGetErrorTextProc;
    fHashFile: TVCertHashFileProc;
    fHashMem: TVCertHashMemProc;
    fInitialize: TVCertInitializeProc;
    fInitializeEx: TVCertInitializeExProc;
    fMatch: TVCertMatchProc;
    fParseCert: TVCertParseCertProc;
    fImportMem: TVCertImportMemProc;
    fImportFile: TVCertImportFileProc;
    fExportMem: TVCertExportMemProc;
    fExportFile: TVCertExportFileProc;
    fDetachSignMem: TVCertDetachSignMemProc;
    fDetachSignFile: TVCertDetachSignFileProc;
    fAttachSignMem: TVCertAttachSignMemProc;
    fAttachSignFile: TVCertAttachSignFileProc;
    fSetAuthData: TVCertSetAuthDataProc;
    fShowCertificate: TVCertShowCertificateProc;
    fSignAndEncryptFile: TVCertSignAndEncryptFileProc;
    fSignAndEncryptMem: TVCertSignAndEncryptMemProc;
    fSignFile: TVCertSignFileProc;
    fSignMem: TVCertSignMemProc;
    fSignedInfoFile: TVCertSignedInfoFileProc;
    fSignedInfoMem: TVCertSignedInfoMemProc;
    fUninitialize: TVCertUninitializeProc;
    fVerifyAndSignFile: TVCertVerifyAndSignFileProc;
    fVerifyAndSignMem: TVCertVerifyAndSignMemProc;
    fVerifyFile: TVCertVerifyFileProc;
    fVerifyMem: TVCertVerifyMemProc;
    fUpdateCRLs: TVCertUpdateCRLsProc;
    fVerifyCert: TVCertVerifyCertProc;
    fReallocMem: TVCertReallocMemProc;
    fSignHashMem: TVCertSignHashMemProc;
    fVerifyHashMem: TVCertVerifyHashMemProc;
    fCopyCert: TVCertCopyCertProc;
    fCtrl: TVCertCtrlProc;
    fCreateSession: TVCertCreateSessionProc;
    fFreeSession: TVCertFreeSessionProc;
    fSessionExport: TVCertSessionExportProc;
    fSessionImport: TVCertSessionImportProc;
    fSessionDerive: TVCertSessionDeriveProc;
    fSessionEncrypt: TVCertSessionEncryptProc;
    fSessionDecrypt: TVCertSessionDecryptProc;
    fCreateConnection: TVCertCreateConnectionProc;
    fFreeConnection: TVCertFreeConnectionProc;
    fClientStep1: TVCertClientStep1Proc;
    fServerStep2: TVCertServerStep2Proc;
    fClientStep3: TVCertClientStep3Proc;
    fServerStep4: TVCertServerStep4Proc;
    fClientStep5: TVCertClientStep5Proc;
    fConnectionEncrypt: TVCertConnectionEncryptProc;
    fConnectionDecrypt: TVCertConnectionDecryptProc;
    fConnectionCtrl: TVCertConnectionCtrlProc;
    fEncodeMem: TVCertEncodeMemProc;
    fDecodeMem: TVCertDecodeMemProc;
    fDuplicateContext: TVCertDuplicateContextProc;
    fVerifyCertificatePolicy: TVCertVerifyCertificatePolicyProc;
    fAuthorize: TVCertAuthorizeProc;
    fGetErrorLine: TVCertGetErrorLineProc;
    fContainerEncryptMem: TVCertContainerEncryptMemProc;
    fContainerDecryptMem: TVCertContainerDecryptMemProc;
    fContainerEncryptedInfoMem: TVCertContainerEncryptedInfoMemProc;
    fContainerEncryptFile: TVCertContainerEncryptFileProc;
    fContainerDecryptFile: TVCertContainerDecryptFileProc;
    fContainerEncryptedInfoFile: TVCertContainerEncryptedInfoFileProc;
    fCheckExpiringCertKey: TVCertCheckExpiringCertKeyProc;
    fParseCrl: TVCertParseCrlProc;
    fFreeCrl: TVCertFreeCrlProc;
    fVerifyCrlPolicy: TVCertVerifyCrlPolicyProc;
    fShowCrl: TVCertShowCrlProc;
    fGetPkcs7InfoMem: TVCertGetPkcs7InfoMemProc;
    fGetPkcs7InfoFile: TVCertGetPkcs7InfoFileProc;
    fFreePkcs7Info: TVCertFreePkcs7InfoProc;
    fStrSignFile: TVCertStrSignFileProc;
    fStrVerifyFile: TVCertStrVerifyFileProc;
    fStrEncryptFile: TVCertStrEncryptFileProc;
    fStrDecryptFile: TVCertStrDecryptFileProc;
    fStrEncryptedInfoFile: TVCertStrEncryptedInfoFileProc;
  public
    constructor Create(const aLocal: Boolean; const aDllName: string);
    destructor Destroy; override;
    function CertificateSize: Integer;
    property VCERT_AddCRL: TVCertAddCRLProc read fAddCRL;
    property VCERT_AddCertificate: TVCertAddCertificateProc read fAddCertificate;
    property VCERT_AllocMem: TVCertAllocMemProc read fAllocMem;
    property VCERT_DecryptAndVerifyFile: TVCertDecryptAndVerifyFileProc read fDecryptAndVerifyFile;
    property VCERT_DecryptAndVerifyMem: TVCertDecryptAndVerifyMemProc read fDecryptAndVerifyMem;
    property VCERT_DecryptFile: TVCertDecryptFileProc read fDecryptFile;
    property VCERT_DecryptMem: TVCertDecryptMemProc read fDecryptMem;
    property VCERT_EncryptFile: TVCertEncryptFileProc read fEncryptFile;
    property VCERT_EncryptMem: TVCertEncryptMemProc read fEncryptMem;
    property VCERT_EncryptedInfoFile: TVCertEncryptedInfoFileProc read fEncryptedInfoFile;
    property VCERT_EncryptedInfoMem: TVCertEncryptedInfoMemProc read fEncryptedInfoMem;
    property VCERT_FindCert: TVCertFindCertProc read fFindCert;
    property VCERT_FreeCert: TVCertFreeCertProc read fFreeCert;
    property VCERT_FreeCertId: TVCertFreeCertIdProc read fFreeCertId;
    property VCERT_FreeDecryptResult: TVCertFreeDecryptResultProc read fFreeDecryptResult;
    property VCERT_FreeEncryptedInfoResult: TVCertFreeEncryptedInfoResultProc read fFreeEncryptedInfoResult;
    property VCERT_FreeFindResult: TVCertFreeFindResultProc read fFreeFindResult;
    property VCERT_FreeMem: TVCertFreeMemProc read fFreeMem;
    property VCERT_FreeSignedInfoResult: TVCertFreeSignedInfoResultProc read fFreeSignedInfoResult;
    property VCERT_FreeVerifyResult: TVCertFreeVerifyResultProc read fFreeVerifyResult;
    property VCERT_GenRandom: TVCertGenRandomProc read fGenRandom;
    function VCERT_GetErrorText(Error: TErrorStatus): string;
    property VCERT_HashFile: TVCertHashFileProc read fHashFile;
    property VCERT_HashMem: TVCertHashMemProc read fHashMem;
    property VCERT_Initialize: TVCertInitializeProc read fInitialize;
    property VCERT_InitializeEx: TVCertInitializeExProc read fInitializeEx;
    property VCERT_Match: TVCertMatchProc read fMatch;
    property VCERT_ParseCert: TVCertParseCertProc read fParseCert;
    property VCERT_ImportMem: TVCertImportMemProc read fImportMem;
    property VCERT_ImportFile: TVCertImportFileProc read fImportFile;
    property VCERT_ExportMem: TVCertExportMemProc read fExportMem;
    property VCERT_ExportFile: TVCertExportFileProc read fExportFile;
    property VCERT_DetachSignMem: TVCertDetachSignMemProc read fDetachSignMem;
    property VCERT_DetachSignFile: TVCertDetachSignFileProc read fDetachSignFile;
    property VCERT_AttachSignMem: TVCertAttachSignMemProc read fAttachSignMem;
    property VCERT_AttachSignFile: TVCertAttachSignFileProc read fAttachSignFile;
    property VCERT_SetAuthData: TVCertSetAuthDataProc read fSetAuthData;
    property VCERT_ShowCertificate: TVCertShowCertificateProc read fShowCertificate;
    property VCERT_SignAndEncryptFile: TVCertSignAndEncryptFileProc read fSignAndEncryptFile;
    property VCERT_SignAndEncryptMem: TVCertSignAndEncryptMemProc read fSignAndEncryptMem;
    property VCERT_SignFile: TVCertSignFileProc read fSignFile;
    property VCERT_SignMem: TVCertSignMemProc read fSignMem;
    property VCERT_SignedInfoFile: TVCertSignedInfoFileProc read fSignedInfoFile;
    property VCERT_SignedInfoMem: TVCertSignedInfoMemProc read fSignedInfoMem;
    property VCERT_Uninitialize: TVCertUninitializeProc read fUninitialize;
    property VCERT_VerifyAndSignFile: TVCertVerifyAndSignFileProc read fVerifyAndSignFile;
    property VCERT_VerifyAndSignMem: TVCertVerifyAndSignMemProc read fVerifyAndSignMem;
    property VCERT_VerifyFile: TVCertVerifyFileProc read fVerifyFile;
    property VCERT_VerifyMem: TVCertVerifyMemProc read fVerifyMem;
    property VCERT_UpdateCRLs: TVCertUpdateCRLsProc read fUpdateCRLs;
    property VCERT_VerifyCert: TVCertVerifyCertProc read fVerifyCert;
    property VCERT_ReallocMem: TVCertReallocMemProc read fReallocMem;
    property VCERT_SignHashMem: TVCertSignHashMemProc read fSignHashMem;
    property VCERT_VerifyHashMem: TVCertVerifyHashMemProc read fVerifyHashMem;
    property VCERT_CopyCert: TVCertCopyCertProc read fCopyCert;
    property VCERT_Ctrl: TVCertCtrlProc read fCtrl;
    property VCERT_CreateSession: TVCertCreateSessionProc read fCreateSession;
    property VCERT_FreeSession: TVCertFreeSessionProc read fFreeSession;
    property VCERT_SessionExport: TVCertSessionExportProc read fSessionExport;
    property VCERT_SessionImport: TVCertSessionImportProc read fSessionImport;
    property VCERT_SessionDerive: TVCertSessionDeriveProc read fSessionDerive;
    property VCERT_SessionEncrypt: TVCertSessionEncryptProc read fSessionEncrypt;
    property VCERT_SessionDecrypt: TVCertSessionDecryptProc read fSessionDecrypt;
    property VCERT_CreateConnection: TVCertCreateConnectionProc read fCreateConnection;
    property VCERT_FreeConnection: TVCertFreeConnectionProc read fFreeConnection;
    property VCERT_ClientStep1: TVCertClientStep1Proc read fClientStep1;
    property VCERT_ServerStep2: TVCertServerStep2Proc read fServerStep2;
    property VCERT_ClientStep3: TVCertClientStep3Proc read fClientStep3;
    property VCERT_ServerStep4: TVCertServerStep4Proc read fServerStep4;
    property VCERT_ClientStep5: TVCertClientStep5Proc read fClientStep5;
    property VCERT_ConnectionEncrypt: TVCertConnectionEncryptProc read fConnectionEncrypt;
    property VCERT_ConnectionDecrypt: TVCertConnectionDecryptProc read fConnectionDecrypt;
    property VCERT_ConnectionCtrl: TVCertConnectionCtrlProc read fConnectionCtrl;
    property VCERT_EncodeMem: TVCertEncodeMemProc read fEncodeMem;
    property VCERT_DecodeMem: TVCertDecodeMemProc read fDecodeMem;
    property VCERT_DuplicateContext: TVCertDuplicateContextProc read fDuplicateContext;
    property VCERT_VerifyCertificatePolicy: TVCertVerifyCertificatePolicyProc read fVerifyCertificatePolicy;
    property VCERT_Authorize: TVCertAuthorizeProc read fAuthorize;
    property VCERT_GetErrorLine: TVCertGetErrorLineProc read fGetErrorLine;
    property VCERT_ContainerEncryptMem: TVCertContainerEncryptMemProc read fContainerEncryptMem;
    property VCERT_ContainerDecryptMem: TVCertContainerDecryptMemProc read fContainerDecryptMem;
    property VCERT_ContainerEncryptedInfoMem: TVCertContainerEncryptedInfoMemProc read fContainerEncryptedInfoMem;
    property VCERT_ContainerEncryptFile: TVCertContainerEncryptFileProc read fContainerEncryptFile;
    property VCERT_ContainerDecryptFile: TVCertContainerDecryptFileProc read fContainerDecryptFile;
    property VCERT_ContainerEncryptedInfoFile: TVCertContainerEncryptedInfoFileProc read fContainerEncryptedInfoFile;
    property VCERT_CheckExpiringCertKey: TVCertCheckExpiringCertKeyProc read fCheckExpiringCertKey;
    property VCERT_ParseCrl: TVCertParseCrlProc read fParseCrl;
    property VCERT_FreeCrl: TVCertFreeCrlProc read fFreeCrl;
    property VCERT_VerifyCrlPolicy: TVCertVerifyCrlPolicyProc read fVerifyCrlPolicy;
    property VCERT_ShowCrl: TVCertShowCrlProc read fShowCrl;
    property VCERT_GetPkcs7InfoMem: TVCertGetPkcs7InfoMemProc read fGetPkcs7InfoMem;
    property VCERT_GetPkcs7InfoFile: TVCertGetPkcs7InfoFileProc read fGetPkcs7InfoFile;
    property VCERT_FreePkcs7Info: TVCertFreePkcs7InfoProc read fFreePkcs7Info;
    property VCERT_StrSignFile: TVCertStrSignFileProc read fStrSignFile;
    property VCERT_StrVerifyFile: TVCertStrVerifyFileProc read fStrVerifyFile;
    property VCERT_StrEncryptFile: TVCertStrEncryptFileProc read fStrEncryptFile;
    property VCERT_StrDecryptFile: TVCertStrDecryptFileProc read fStrDecryptFile;
    property VCERT_StrEncryptedInfoFile: TVCertStrEncryptedInfoFileProc read fStrEncryptedInfoFile;
  end;

implementation

uses
  TypInfo;

resourcestring
  rsMissingDll   = '    "" %s     ';
  rsMissingProc  = '   "" %s   %s';
  rsUnknownError = ' ';

function GetProcName(I: TDLLProcs): string;
begin
  Result := 'VCERT_' + Copy(GetEnumName(TypeInfo(TDLLProcs), Integer(I)), 3, MaxInt);
end;

function VCERT_BASE64_LEN(vlen: Integer): Integer;
begin
  Result := (((vlen) * 4 div 3 ) + 3 + 1);
end;

function KnownMissingProcs(const Proc: TDLLProcs; const LocalCryptography: boolean): Boolean;
begin
  if LocalCryptography then
  begin
    Result := Proc in [fnAuthorize, fnContainerEncryptMem, fnContainerDecryptMem,
                       fnContainerEncryptedInfoMem, fnContainerEncryptFile,
                       fnContainerDecryptFile, fnContainerEncryptedInfoFile];
  end
  else begin
    Result := Proc in [fnGetPkcs7InfoMem, fnGetPkcs7InfoFile, fnFreePkcs7Info,
                       fnStrSignFile, fnStrVerifyFile, fnStrEncryptFile, fnStrDecryptFile, fnStrEncryptedInfoFile,
                       fnShowCrl, fnShowCertificate, fnUpdateCrls, fnCreateSession,
                       fnClientStep1, fnServerStep2, fnClientStep3, fnServerStep4,
                       fnClientStep5, fnGetErrorLine, fnCreateSession,
                       fnFreeSession, fnSessionExport, fnSessionImport, fnSessionDerive,
                       fnSessionEncrypt, fnSessionDecrypt, fnCreateConnection, fnFreeConnection,
                       fnConnectionEncrypt, fnConnectionDecrypt, fnConnectionCtrl,
                       fnEncodeMem, fnDecodeMem,
                       fnContainerEncryptMem, fnContainerDecryptMem,
                       fnContainerEncryptedInfoMem, fnContainerEncryptFile, fnContainerDecryptFile,
                       fnContainerEncryptedInfoFile, fnCheckExpiringCertKey];
  end;
end;

constructor TVCERTApi.Create(const aLocal: Boolean; const aDllName: string);
var
  P: PPointer; //^FARPROC;
  I: TDLLProcs;
  ProcName: string;
begin
//  Assert(SizeOf(TOpaqueCertificate) = SizeOf(TCertificate), 'SizeOf(TOpaqueCertificate) <> Sizeof(TCertificate)');
  fDllHandle := LoadLibrary(@aDllName[1]);
  if fDllHandle = 0 then
  begin
    try
      RaiseLastOSError;
    except
      on E: Exception do begin
        E.Message := 'Error while loading library ' + aDllName + #13#10 + E.Message;
        raise;
      end;
    end;
  end;

  P := @@fAddCRL;
  for I := Low(TDLLProcs) to High(TDLLProcs) do
  begin
    ProcName := GetProcName(I);
    P^ := GetProcAddress(fDllHandle, PChar(ProcName));
    if (not Assigned(P^)) and not KnownMissingProcs(I, aLocal) then
      raise EVCERTApiMissingProcs.CreateFmt(rsMissingProc, [aDllName, ProcName]);
    Inc(P);
  end;
end;

destructor TVCERTApi.Destroy;
begin
  if fDllHandle <> 0 then FreeLibrary(fDllHandle);
  inherited;
end;

function TVCERTApi.CertificateSize: Integer;
begin
  Result := SizeOf(TCertificate);
end;

function TVCERTApi.VCERT_GetErrorText(Error: TErrorStatus): string;
var
  MsgBuf: array [0..1023] of AnsiChar;
begin
  fGetErrorText(Error, MsgBuf, SizeOf(MsgBuf));
  Result := Trim(AnsiString(MsgBuf));
end;

end.

