unit DocReceiv;
interface
uses
  SysUtils, Classes, XMLUtil,Dialogs, WServUtils;

type
  TPackageItem = class(TCollectionItem)
  private
    FFileSize: longint;
    FPackageId: string;
    FFileName: string;
    FHash: string;
  public
    property PackageId: string read FPackageId write FPackageId;
    property FileName: string read FFileName write FFileName;
    property FileSize: longint read FFileSize write FFileSize;
    property Hash: string read FHash write FHash;
  end;

  TPackageCollection = class(TCollection)
  private
    function GetItem(Index: Integer): TPackageItem;
    procedure SetItem(Index: Integer; const Value: TPackageItem);
  public
    property Items[Index: longint]: TPackageItem read GetItem write SetItem; default;
  end;

  TWSReceiver = class(TCollectionItem)
  protected
    FPackageCollection: TPackageCollection;
    function MessageCount: integer;
    function MessageAttachCount(MessageIndex: integer): integer;
    function GetOriginalFileName(MessageIndex, AttachIndex: integer): string;
    procedure SaveAttachFile(MessageIndex, AttachIndex: integer; FileName: string);
    procedure FinalizationMessageList;
  public
    constructor Create;
    destructor Destroy;
  end;

var
  Receiver : TWSReceiver;

function PackageListXmlToPackageCollection(Value: string): TPackageCollection;

function GetDocPackageList(const ADate: TDateTime; SDir : String): Boolean;

implementation
uses
  CriptU, MSXML2_TLB;

function PackageListXmlToPackageCollection(Value: string): TPackageCollection;
var
  xml : TXMLDocHelper;
  node: IXMLDOMNode;
  packageItem: TPackageItem;
begin
  Result := TPackageCollection.Create(TPackageItem);
  xml := TXMLDocHelper.Create(nil);
  try
    xml.LoadFromString(Value);
    node := xml.NodeByName(xml.Root, 'package');
    PreScanXML;
    while ScanXML(node, 'package') do begin
      packageItem := TPackageItem.Create(Result);
      packageItem.PackageId := xml.NodeByName(node, 'id').text;
      packageItem.FileName := xml.NodeByName(node, 'name').text;
      packageItem.FileSize := StrToInt(xml.NodeByName(node, 'size').text);
      packageItem.Hash := xml.NodeByName(node, 'hash').text;
    end;
  finally
    xml.Free;
  end;
end;

function GetDocPackageList(const ADate: TDateTime; SDir : String): Boolean;
var
  S : String;
  i, packCount : integer;
begin
  Result := False;
  try
    MCryptForm.LogMemo.Lines.Add('   (-) ...');
    try
      Receiver := TWSReceiver.Create;
      if Assigned(Receiver.FPackageCollection) then
      Receiver.FPackageCollection := PackageListXmlToPackageCollection(WebService.GetPackageList(ADate));
      packCount := Receiver.MessageCount;
      MCryptForm.LogMemo.Lines.Add('->  ' + IntToStr(packCount) + '   ' + MCryptForm.PCodEdit.Text);
      if packCount > 0 then
      begin
        for I := 0 to packCount - 1 do
        begin
          with MCryptForm.LogMemo.Lines do
          begin
            Add('--- # ' + IntToStr(I) + ' -----------');
            Add(': ' + Receiver.GetOriginalFileName(I, 1));
            Add(': ' + IntToStr(Receiver.FPackageCollection.GetItem(I).FileSize));
          end;
        end;
        MCryptForm.LogMemo.Lines.Add('=====   =======================');
        for I := 0 to packCount - 1 do
        begin
          with MCryptForm.LogMemo.Lines do
          begin
            Add('---  # ' + IntToStr(I) + ' ---------');
            Add(': ' + Receiver.GetOriginalFileName(I, 1));
            Add(': ' + IntToStr(Receiver.FPackageCollection.GetItem(I).FileSize));
            Add(' : [' + SDir + ']');
            Receiver.SaveAttachFile(I, 1, SDir + Receiver.GetOriginalFileName(I, 1));
            Add('-> Ok');
          end;
        end;
      end else MCryptForm.LogMemo.Lines.Add(' ...');
    finally
      Receiver.Free;
    end;
    Result := True;
  except
    on E: Exception do
      MCryptForm.LogMemo.Lines.Add('!-> Error: ' + E.Message);
  end;
end;
{ TWSReceiver }

constructor TWSReceiver.Create;
begin
  FPackageCollection := TPackageCollection.Create(TPackageItem);
end;

destructor TWSReceiver.Destroy;
begin
  if Assigned(FPackageCollection) then FreeAndNil(FPackageCollection);
  inherited;
end;

procedure TWSReceiver.FinalizationMessageList;
begin
  inherited;
  FreeAndNil(FPackageCollection);
end;

function TWSReceiver.GetOriginalFileName(MessageIndex,
  AttachIndex: integer): string;
begin
  Result := ExtractFileName(FPackageCollection[MessageIndex].FileName);
end;

function TWSReceiver.MessageAttachCount(MessageIndex: integer): integer;
begin
  Result := 1;
end;

function TWSReceiver.MessageCount: integer;
begin
  Result := FPackageCollection.Count;
end;

procedure TWSReceiver.SaveAttachFile(MessageIndex, AttachIndex: integer;
  FileName: string);
begin
  WebService.GetPackage(FPackageCollection.Items[MessageIndex].PackageId, FileName, FPackageCollection.Items[MessageIndex].FileSize);
end;

{ TPackageCollection }

function TPackageCollection.GetItem(Index: Integer): TPackageItem;
begin
  Result := TPackageItem(inherited GetItem(Index))
end;

procedure TPackageCollection.SetItem(Index: Integer; const Value: TPackageItem);
begin
  inherited SetItem(Index, Value);
end;

end.
