unit CriptU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Menus, StdActns, ActnList, FileCtrl, TimeDate,
  vcert, vcerterr, Reg, WindowsZIP, ComCtrls, Buttons, ToolWin, ExtDlgs, Grids,
  ValEdit, DB, DBClient, WslService,WServUtils, DocReceiv, IdBaseComponent,
  IdComponent, IdServerIOHandler, IdServerIOHandlerSocket,
  IdServerIOHandlerStack;

type
  TMCryptForm = class(TForm)
    AL: TActionList;
    acCryptoKeyDict: TAction;
    acCryptoInit: TAction;
    acSignFile: TAction;
    acEncryptFile: TAction;
    acDecryptFile: TAction;
    acCheckFileSign: TAction;
    acExit: TAction;
    acAttachSign: TAction;
    acDetachSign: TAction;
    acShowCryptoSessions: TAction;
    MainMenu2: TMainMenu;
    N20: TMenuItem;
    N127: TMenuItem;
    N22: TMenuItem;
    CriptoMnu: TMenuItem;
    N58: TMenuItem;
    N107: TMenuItem;
    N59: TMenuItem;
    N60: TMenuItem;
    N61: TMenuItem;
    N62: TMenuItem;
    N37: TMenuItem;
    N53: TMenuItem;
    NAttachDetach: TMenuItem;
    N63: TMenuItem;
    N64: TMenuItem;
    N65: TMenuItem;
    N66: TMenuItem;
    N67: TMenuItem;
    ODSign: TOpenDialog;
    DLLGBox: TGroupBox;
    DLLComboBox: TComboBox;
    ODToZip: TOpenDialog;
    acCreateZIP: TAction;
    acUnZIP: TAction;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    acBatchSend: TAction;
    acBatchReceive: TAction;
    LogGBox: TGroupBox;
    ToolBar1: TToolBar;
    ClearLogToolButton: TToolButton;
    SaveLogToolButton: TToolButton;
    SaveTextFileDialog: TSaveTextFileDialog;
    SertListGBox: TGroupBox;
    SertListPanel: TPanel;
    LogPanel: TPanel;
    LogMemo: TMemo;
    LokalCryptoPathGBox: TGroupBox;
    Panel1: TPanel;
    SelectDirSButton: TSpeedButton;
    CryptDirEdit: TEdit;
    SertLisMemo: TMemo;
    acFindAllLocalSert: TAction;
    ToolBar2: TToolBar;
    ClearSertListToolButton: TToolButton;
    SaveSertListToolButton: TToolButton;
    FindAllLocalSertToolButton: TToolButton;
    SignAttachedMnu: TMenuItem;
    SignDettachedMnu: TMenuItem;
    acSignAttachedFile: TAction;
    acSignDetachedFile: TAction;
    WEBServGBox: TGroupBox;
    WEBGridPanel: TGridPanel;
    URLLabel: TLabel;
    URLEdit: TEdit;
    PCodLabel: TLabel;
    PCodEdit: TEdit;
    WEB1: TMenuItem;
    WEBSendMnu: TMenuItem;
    WEBReceiveMnu: TMenuItem;
    acWEBSend: TAction;
    acWEBReceive: TAction;
    DateLabel: TLabel;
    DateReceive: TDateTimePicker;
    IdServerIOHandlerStack1: TIdServerIOHandlerStack;
    procedure FormCreate(Sender: TObject);
    procedure acCryptoInitExecute(Sender: TObject);
    procedure acSignFileExecute(Sender: TObject);
    procedure acAttachSignExecute(Sender: TObject);
    procedure acDetachSignExecute(Sender: TObject);
    procedure acCreateZIPExecute(Sender: TObject);
    procedure LogMemoChange(Sender: TObject);
    procedure acEncryptFileExecute(Sender: TObject);
    procedure acDecryptFileExecute(Sender: TObject);
    procedure acBatchSendExecute(Sender: TObject);
    procedure acBatchReceiveExecute(Sender: TObject);
    procedure acUnZIPExecute(Sender: TObject);
    procedure acCheckFileSignExecute(Sender: TObject);
    procedure acExitExecute(Sender: TObject);
    procedure ClearLogToolButtonClick(Sender: TObject);
    procedure SaveLogToolButtonClick(Sender: TObject);
    procedure SelectDirSButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CryptDirEditChange(Sender: TObject);
    procedure acFindAllLocalSertExecute(Sender: TObject);
    procedure ClearSertListToolButtonClick(Sender: TObject);
    procedure SaveSertListToolButtonClick(Sender: TObject);
    procedure acSignDetachedFileExecute(Sender: TObject);
    procedure acSignAttachedFileExecute(Sender: TObject);
    procedure acWEBSendExecute(Sender: TObject);
    procedure acWEBReceiveExecute(Sender: TObject);
  private
    { Private declarations }
    function AttachSignFile(FileName, DataFileName, SignFileName : String): TErrorStatus;
    procedure SignFile(FileName: String; SignAttached: boolean);
    function DetachSign(FileName, DataFileName, SignFileName : String) : TErrorStatus;
    function SignDetachFile(const DataFileName,  SignedFileName: string) : TErrorStatus;
    function SignAttachFile(const DataFileName: string) : TErrorStatus;
    function CheckLocalCriptRefs(DirName: string): Boolean;
    function InternalGetSignCount(SignFileName: string): integer;
    function ScanDir(sDir: string): Boolean;
    function EncryptFile(FileName: String) : Boolean;
    function EncryptFileFromListCert(FileName: String; Lines: TStrings) : Boolean;
    function EncryptFileFromIntListCert(FileName, Tamplet : String) : Boolean;
    function VerifyFile(FileName: String) : TErrorStatus;
    function DecryptFile(FileName: String) : TErrorStatus;
    procedure FileReceiveProc(FileName: String);
    procedure FindAllLocalSert;
    function GetCountSertOfLine(Line: String) : Integer;
    function GetCountSerts(Lines: TStrings) : Integer;
    function CheckWEBParam : Boolean;
    procedure SendTrnPackage(FileName: string);
  public
    { Public declarations }
    procedure SignStringToStream(Value: AnsiString; Stream: TStream);
    procedure GetMemHashStream(MemIn: string; out AStream: TMemorystream);
    function CheckStringSign(str, sgn: AnsiString): boolean;
  end;

var
  MCryptForm: TMCryptForm;
  Api: TVCERTApi;
  Context: TContext;
  g_ValidataGlobalGuard: TRTLCriticalSection;
  ChosenZIPDir: string;

  sSignExt  : String = '.SGN';
  sSignInt  : String = '.SGNInt';
  sSignCrypt  : String = '.CRY';
  sDir : String = 'C:\';

implementation

{$R *.dfm}

const
  CryptTmp = 'CryptoSamplTmp';
  RegBasePathKey = 'Software\Validata\NSDSampl';
  BasePathParamName = 'BasePathSpr';
  MyCertList = 'MyCertList';
  MyPersonCode = 'MyPersonCode';
  WEBServURL = 'WEBServURL';

function CreateMemBlk(Buf: PByte; Len: Integer): TMemBlk;
begin
  Result.len := Len;
  Result.buf := Buf;
end;

procedure TMCryptForm.acAttachSignExecute(Sender: TObject);
var
  FileName: string;
  ErrorCode : TErrorStatus;
begin
  if ODSign.Execute() then
  begin
    FileName := ODSign.FileName;
    if FileExists(ChangeFileExt(FileName, sSignExt)) then
    begin
      acCryptoInit.Execute;
      ErrorCode := AttachSignFile(FileName, ChangeFileExt(FileName, sSignInt), ChangeFileExt(FileName, sSignExt));
    end else LogMemo.Lines.Add('->  ' + FileName + '  .');
  end;
end;

procedure TMCryptForm.acBatchReceiveExecute(Sender: TObject);
Var
  OldFilter, OldTitle, ArcFileName, MyTmpDir : String;
  ErrorCode : TErrorStatus;
begin //
  try
    with ODSign do
    begin
      OldFilter := Filter;
      OldTitle := Title;
      Filter := '  (*.CRY)|*.CRY';
      Title := '   ';
      if Execute() then
      begin
        acCryptoInit.Execute;
        ErrorCode := DecryptFile(FileName);
        if ErrorCode = VCERT_OK then
        begin
          ArcFileName := ChangeFileExt(FileName, '.zip');
          MyTmpDir := GetMyTempDir(CryptTmp);
          LogMemo.Lines.Add('->    [' + MyTmpDir + ']');
          if KillDir(AnsiString(MyTmpDir)) then LogMemo.Lines.Add('-> Ok ');
          MyTmpDir := GetMyTempDir(CryptTmp);
          if WZIP_ExtractAll(IncludeTrailingPathDelimiter(MyTmpDir), ArcFileName) then
          begin
            LogMemo.Lines.Add('-> Ok ');
            if ScanDir(IncludeTrailingPathDelimiter(MyTmpDir)) then
            begin  // ZIP     
              LogMemo.Lines.Add('->    [' + MyTmpDir + ']');
              if WZIP_ZipDirAll(ArcFileName, IncludeTrailingPathDelimiter(MyTmpDir)) then
              LogMemo.Lines.Add('-> Ok ');
            end;
          end else  LogMemo.Lines.Add('->    ' + FileName);
        end else LogMemo.Lines.Add('->    ' + ArcFileName + ' Error#=' + IntToStr(ErrorCode) +
                           ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
      end;
    end;
  finally
    with ODSign do
    begin
      Filter := OldFilter;
      Title := OldTitle;
    end;
  end;
end;

procedure TMCryptForm.acBatchSendExecute(Sender: TObject);
Var
  OldFilter, OldTitle, ArcFileName : String;
  SZipFName : TStringList;
begin //
  try
    SZipFName := TStringList.Create;
    SZipFName.Clear;
    with ODSign do
    begin
      if Trim(SertLisMemo.Lines.Text) = '' then
      begin
        LogMemo.Lines.Add('->          ... ');
        Exit;
      end;
      OldFilter := Filter;
      OldTitle := Title;
      Filter := '  (*.*)|*.*';
      Title := '     ';
      if Execute() then
      begin
        acCryptoInit.Execute;
        SignFile(FileName, True);
        ArcFileName := ChangeFileExt(FileName, '.zip');
        with LogMemo.Lines do
        begin
          Add('->  : ' + FileName);
          Add('->  : ' + ArcFileName);
        end;
        SZipFName.Add(FileName);
        if WZIP_Make(ArcFileName, SZipFName) then
        begin
          if EncryptFileFromListCert(ArcFileName, SertLisMemo.Lines) then LogMemo.Lines.Add('-> Ok')
          else LogMemo.Lines.Add('->    ' + ArcFileName);
        end else LogMemo.Lines.Add('->    ' + ArcFileName);
      end;
    end;
  finally
    with ODSign do
    begin
      Filter := OldFilter;
      Title := OldTitle;
      SZipFName.Free;
    end;
  end;
end;

procedure TMCryptForm.acCheckFileSignExecute(Sender: TObject);
Var
  OldFilter, OldTitle : String;
  ErrorCode : TErrorStatus;
begin
  try
    with ODSign do
    begin
      OldFilter := Filter;
      OldTitle := Title;
      Filter := '  (*.*)|*.*';
      Title := '    ';
      if Execute() then
      begin
        acCryptoInit.Execute;
        ErrorCode := VerifyFile(FileName);
       if ErrorCode = VCERT_OK then LogMemo.Lines.Add('->   [' + FileName + ']')
       else
       LogMemo.Lines.Add('->   [' + FileName + '] Error#=' + IntToStr(ErrorCode) +
                           ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
      end;
    end;
  finally
    with ODSign do
    begin
      Filter := OldFilter;
      Title := OldTitle;
    end;
  end;
end;

procedure TMCryptForm.acCreateZIPExecute(Sender: TObject);
var
  ArcFileName: string;
  SourseFile : TStringList;
begin
  try
    SourseFile := TStringList.Create;
    SourseFile.Clear;
    ODToZip.Filter := ' ZIP (*.zip)|*.zip';
    ODToZip.Title := '  ';
    ODToZip.Options := ODToZip.Options - [ofAllowMultiSelect];
    if ODToZip.Execute() then
    begin
      ArcFileName := ChangeFileExt(ODToZip.FileName, '.zip');
      ODToZip.Filter := '  (*.*)|*.*';
      ODToZip.Title := '   ';
      ODToZip.Options := ODToZip.Options + [ofAllowMultiSelect];
      if ODToZip.Execute() then
      begin
        SourseFile.AddStrings(ODToZip.Files);
        LogMemo.Lines.Add('->  : ' + SourseFile.Text);
        LogMemo.Lines.Add('->  : ' + ArcFileName);
        if Not WZIP_Make(ArcFileName, SourseFile) then
        begin
          LogMemo.Lines.Add('   ' + ArcFileName);
        end;
      end;
    end;
  finally
    SourseFile.Free;
  end;
end;

procedure TMCryptForm.acCryptoInitExecute(Sender: TObject);
var
  Params: TLocalParam;
  ErrorCode: TErrorStatus;
begin
  if Assigned(Api) then
  begin
    LogMemo.Lines.Add('  .   ');
    Exit;
  end;
  Api := TVCERTApi.Create(True, DLLComboBox.Items.Strings[DLLComboBox.ItemIndex]);
  FillChar(Params, SizeOf(Params), 0);
  Params.Size := SizeOf(Params);
  Params.Flag := 0;
  Params.pse := PAnsiChar(AnsiString('pse://signed/' + CryptDirEdit.Text + '\local.pse'));
  Params.LocalStore := PAnsiChar(AnsiString('file://' + CryptDirEdit.Text + '\local.gdbm'));
  Params.Ldap := PAnsiChar(AnsiString(''));

  LogMemo.Lines.Add('->  ');
  InitializeCriticalSection(g_ValidataGlobalGuard);
  EnterCriticalSection(g_ValidataGlobalGuard);
  try
    ErrorCode := Api.VCERT_InitializeEx(CRYPT_LOCAL, @Params, Context);
    if ErrorCode = VCERT_OK then LogMemo.Lines.Add('-> Ok')
    else LogMemo.Lines.Add('->    ErrCode#=' + IntToStr(ErrorCode) +
                           ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
  finally
    LeaveCriticalSection(g_ValidataGlobalGuard);
  end;
end;

procedure TMCryptForm.acDecryptFileExecute(Sender: TObject);
Var
  OldFilter : String;
begin
  try
    with ODSign do
    begin
      OldFilter := Filter;
      Filter := 'CRY  (*.cry)|*.cry';
      if Execute() then
      begin
        acCryptoInit.Execute;
        DecryptFile(FileName);
      end;
    end;
  finally
    ODSign.Filter := OldFilter;
  end;
end;

procedure TMCryptForm.acDetachSignExecute(Sender: TObject);
var
  FileName: string;
  ErrorCode: TErrorStatus;
begin
  if ODSign.Execute() then
  begin
    acCryptoInit.Execute;
    FileName := ODSign.FileName;
    ErrorCode := DetachSign(FileName, ChangeFileExt(FileName, '_$$$_'), ChangeFileExt(FileName, sSignExt));
  end;
end;

procedure TMCryptForm.acEncryptFileExecute(Sender: TObject);
Var
  OldFilter, OldTitle : String;
begin
  try
    with ODSign do
    begin
      OldFilter := Filter;
      OldTitle := Title;
      Filter := 'ZIP  (*.zip)|*.zip';
      if Execute() then
      begin
        acCryptoInit.Execute;
        EncryptFileFromIntListCert(FileName, '*');
      end;
    end;
  finally
    with ODSign do
    begin
      Filter := OldFilter;
      Title := OldTitle;
    end;
  end;
end;

procedure TMCryptForm.acExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TMCryptForm.acFindAllLocalSertExecute(Sender: TObject);
begin
  acCryptoInit.Execute;
  FindAllLocalSert;
end;

procedure TMCryptForm.acSignAttachedFileExecute(Sender: TObject);
begin
  if ODSign.Execute() then if acCryptoInit.Execute then SignFile(ODSign.FileName, True);
end;

procedure TMCryptForm.acSignDetachedFileExecute(Sender: TObject);
begin
  if ODSign.Execute() then if acCryptoInit.Execute then SignFile(ODSign.FileName, False);
end;

procedure TMCryptForm.acSignFileExecute(Sender: TObject);
begin
  if ODSign.Execute() then if acCryptoInit.Execute then SignFile(ODSign.FileName, False);
end;

procedure TMCryptForm.acUnZIPExecute(Sender: TObject);
var
  OldFilter, OldTitle  : String;
  ArcFileName: string;
begin
  try
    with ODSign do
    begin
      OldFilter := Filter;
      OldTitle := Title;
      Filter := ' ZIP (*.zip)|*.zip';
      Title := '   ';
      if Execute() then
      begin
       if SelectDirectory('    ', '\', ChosenZIPDir, [sdNewFolder, sdShowEdit, sdShowShares, sdNewUI]) then
       begin
         LogMemo.Lines.Add('->   ' + FileName);
         LogMemo.Lines.Add('->   ' + IncludeTrailingPathDelimiter(ChosenZIPDir));
         if WZIP_ExtractAll(IncludeTrailingPathDelimiter(ChosenZIPDir), FileName) then
         begin
           LogMemo.Lines.Add('-> Ok ');
         end else  LogMemo.Lines.Add('->    ' + FileName);
       end;
      end;
    end;
  finally
    with ODSign do
    begin
      Filter := OldFilter;
      Title := OldTitle;
    end;
  end;
end;

procedure TMCryptForm.acWEBReceiveExecute(Sender: TObject);
begin
  if Not CheckWEBParam then Exit;
  if SelectDirectory('     ', '\', ChosenZIPDir, [sdNewFolder, sdShowEdit, sdShowShares, sdNewUI]) then
  begin
    LogMemo.Lines.Add('->   ( WEB )' + IncludeTrailingPathDelimiter(ChosenZIPDir));
    if GetDocPackageList(DateReceive.Date, IncludeTrailingPathDelimiter(ChosenZIPDir)) then
    begin
      LogMemo.Lines.Add('-> Ok');
    end else LogMemo.Lines.Add('->   ');
  end;
end;

procedure TMCryptForm.acWEBSendExecute(Sender: TObject);
Var
  OldFilter, OldTitle : String;
begin
  if Not CheckWEBParam then Exit;
  try
    with ODSign do
    begin
      OldFilter := Filter;
      OldTitle := Title;
      Filter := '  (*.CRY)|*.CRY'{|  (*.*)|*.*'};
      Title := '   ';
      if Execute() then
      begin
        SendTrnPackage(FileName);
      end;
    end;
  finally
    with ODSign do
    begin
      Filter := OldFilter;
      Title := OldTitle;
    end;
  end;
end;

function TMCryptForm.AttachSignFile(FileName, DataFileName,
  SignFileName: String): TErrorStatus;
begin
  LogMemo.Lines.Add('->     ' + FileName);
  Result := Api.VCERT_AttachSignFile(Context, PAnsiChar(AnsiString(FileName)),
                                        PAnsiChar(AnsiString(SignFileName)), //   [.SNG]
                                        PAnsiChar(AnsiString(DataFileName))); //  .
  if Result = VCERT_OK then LogMemo.Lines.Add('-> Ok')
  else
  begin
    LogMemo.Lines.Add('->    ErrCode# = ' + IntToStr(Result) +
                      ' [' + Api.VCERT_GetErrorText(Result) + ']');
    Exit;
  end;
  if FileExists(FileName) then
  if DeleteFile(FileName) then
  begin
    with LogMemo.Lines do
    begin
      Add('->   ' + FileName);
      Add('-> Ok');
    end;
    if FileExists(DataFileName) then
    if RenameFile(DataFileName, FileName) then
    begin
      with LogMemo.Lines do
      begin
        Add('->   ' + FileName);
        Add('-> Ok');
      end;
      if FileExists(SignFileName) then
      if DeleteFile(SignFileName) then
      begin
        with LogMemo.Lines do
        begin
          Add('->   ' + SignFileName);
          Add('-> Ok');
        end;
      end else LogMemo.Lines.Add('->    ' + SignFileName);
    end else LogMemo.Lines.Add('->     ');
  end else LogMemo.Lines.Add('->    ' + FileName);
end;

function TMCryptForm.CheckLocalCriptRefs(DirName: string): Boolean;
begin
  Result := False;
  if FileExists(DirName + 'local.pse') and FileExists(DirName + 'local.gdbm') then Result := True;
end;

function TMCryptForm.CheckStringSign(str, sgn: AnsiString): boolean;
var
  FileName, SgnFileName: string;
  FS: TFileStream;

begin
  FileName := GetTempDir + 'tmp.file';
  SgnFileName := ChangeFileExt(FileName, sSignExt);

  FS := TFileStream.Create(FileName, fmCreate);
  try
    FS.WriteBuffer(Pointer(str)^, Length(str));
  finally
    FS.Free;
  end;

  FS := TFileStream.Create(SgnFileName, fmCreate);
  try
    FS.WriteBuffer(Pointer(sgn)^, Length(sgn));
  finally
    FS.Free;
  end;
  Result := VerifyFile(FileName) = 0;
  SysUtils.DeleteFile(FileName);
  SysUtils.DeleteFile(SgnFileName);
end;

function TMCryptForm.CheckWEBParam: Boolean;
begin
  Result := False;
  if Trim(URLEdit.Text) = '' then
  begin
    LogMemo.Lines.Add('!-> .  ');
    Exit;
  end;
  if Trim(PCodEdit.Text) = '' then
  begin
    LogMemo.Lines.Add('!-> .   ');
    Exit;
  end;
  Result := True;
end;

procedure TMCryptForm.ClearLogToolButtonClick(Sender: TObject);
begin
  LogMemo.Clear;
end;

procedure TMCryptForm.CryptDirEditChange(Sender: TObject);
begin
  CriptoMnu.Enabled := CheckLocalCriptRefs(IncludeTrailingPathDelimiter(Trim(CryptDirEdit.Text)));
end;

function TMCryptForm.DetachSign(FileName, DataFileName, SignFileName : String): TErrorStatus;
Var
  SignCount : Integer;
begin
  result := 999999;
  acCryptoInit.Execute;
  SignCount := InternalGetSignCount(FileName);
  if SignCount > 0 then
  begin
    LogMemo.Lines.Add('->     ' + FileName);
    result := Api.VCERT_DetachSignFile(Context, PAnsiChar(AnsiString(FileName)),
                                                PAnsiChar(AnsiString(DataFileName)),
                                                PAnsiChar(AnsiString(SignFileName)));
    if Result = VCERT_OK then
    begin
      LogMemo.Lines.Add('-> Ok');
      if FileExists(FileName) then
         if DeleteFile(FileName) then
         begin
           if FileExists(DataFileName) then
           if RenameFile(DataFileName, FileName) then
           begin
             LogMemo.Lines.Add('->   ' + FileName);
             LogMemo.Lines.Add('-> Ok');
           end else  LogMemo.Lines.Add('->    ' + DataFileName);
         end else LogMemo.Lines.Add('->    ' + FileName);
    end else LogMemo.Lines.Add('-> ErrCode = ' + IntToStr(Result) +
                               ' [' + Api.VCERT_GetErrorText(Result) + ']');
  end
  else
  begin
    LogMemo.Lines.Add('->  ' + FileName + '  .');
  end;
end;

function TMCryptForm.EncryptFile(FileName: String): Boolean;
var
  EncryptParams: TEncryptParams;
  FindParam : TFindParams;
  FindResult : TFindResult;
  ErrorCode : TErrorStatus;

begin
  Result := False;
  LogMemo.Lines.Add('->   ' + FileName);
  FillChar(EncryptParams, SizeOf(EncryptParams), 0);
  EncryptParams.MyCert := Nil; // 
  EncryptParams.ReceiverNum := 1;
  EncryptParams.Flag := FLAG_PKCS7;
  FillChar(FindParam, SizeOf(FindParam), 0);
  FillChar(FindResult, SizeOf(FindResult), 0);

//  FindParam.flag := [FLAG_FIND_MY];
  FindParam.info := [FIELD_SUBJECT]+[FIELD_CERTHASH];
  try
    ErrorCode := Api.VCERT_FindCert(Context, @FindParam, FindResult);
    if ErrorCode = VCERT_OK then
    begin
      LogMemo.Lines.Add('->  . .=' + IntToStr(FindResult.num));
      EncryptParams.Receivers := FindResult.Certs;
      ErrorCode := Api.VCERT_EncryptFile(Context, @EncryptParams, PAnsiChar(AnsiString(FileName)),
                                  PAnsiChar(AnsiString(ChangeFileExt(FileName, sSignCrypt))));
      if ErrorCode <> VCERT_OK then
      begin
        LogMemo.Lines.Add('->    ' + FileName + '] Error#=' + IntToStr(ErrorCode) +
                           ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
        Exit;
      end
      else
      begin
        LogMemo.Lines.Add('->  ' + FileName + ' ..');
        LogMemo.Lines.Add('->   ' + ChangeFileExt(FileName, sSignCrypt));
        LogMemo.Lines.Add('-> Ok');
        Result := True;
      end;
    end
    else
    begin
      LogMemo.Lines.Add('->   . Error#=' + IntToStr(ErrorCode) +
                                       ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
      Exit;
    end;
  finally
    Api.VCERT_FreeFindResult(Context, FindResult);
  end;
end;

function TMCryptForm.EncryptFileFromIntListCert(FileName,
  Tamplet: String): Boolean;
var
  I, Num : Integer;
  EncryptParams: TEncryptParams;
  FindParam : TFindParams;
  FindResult : TFindResult;
  ErrorCode : TErrorStatus;
  AllCertsCount : Integer;
  Certificat : TCertificate;
  Certificates, PC : PCertificate;

begin
  Result := False;
  LogMemo.Lines.Add('->   ' + FileName);
  if Trim(Tamplet) = '' then
  begin
    LogMemo.Lines.Add('->          ... ');
    Exit;
  end;
  FillChar(EncryptParams, SizeOf(EncryptParams), 0);
  FillChar(ErrorCode, SizeOf(ErrorCode), 0);
  EncryptParams.MyCert := Nil; // 
  EncryptParams.Flag := FLAG_PKCS7;
  try
    FillChar(FindParam, SizeOf(FindParam), 0);
    FillChar(FindResult, SizeOf(FindResult), 0);
    with FindParam do
    begin
      MyCert := Nil;
      Flag := [FLAG_FIND_SELECTUI];
      CertTemplate.Fields := [FIELD_SUBJECT];
      CertTemplate.Subject := PAnsiChar(AnsiString(Trim(Tamplet)));
      info := [FIELD_SUBJECT]+[FIELD_CERTHASH];
    end;
    LogMemo.Lines.Add('->    ...');
    ErrorCode := Api.VCERT_FindCert(Context, @FindParam, FindResult);
    if ErrorCode = VCERT_OK then
    begin
      Num := FindResult.Num;
      LogMemo.Lines.Add('->  ' + IntToStr(Num) + '   ...');
      with EncryptParams do
      begin
        ReceiverNum := Num;
        Receivers := FindResult.Certs;
      end;
    end
    else
    begin
      LogMemo.Lines.Add('->   . Error#=' + IntToStr(ErrorCode) +
                        ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
      Exit;
    end;
    ErrorCode := Api.VCERT_EncryptFile(Context, @EncryptParams, PAnsiChar(AnsiString(FileName)),
                              PAnsiChar(AnsiString(ChangeFileExt(FileName, sSignCrypt))));
    if ErrorCode <> VCERT_OK then
    begin
      LogMemo.Lines.Add('->    ' + FileName + '] Error#=' + IntToStr(ErrorCode) +
                        ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
      Exit;
    end
    else
    begin
      with LogMemo.Lines do
      begin
        Add('->  ' + FileName + ' ..');
        Add('->   ' + ChangeFileExt(FileName, sSignCrypt));
        Add('-> Ok');
      end;
      Result := True;
    end;
  finally
    Api.VCERT_FreeFindResult(Context, FindResult);
  end;
end;

function TMCryptForm.EncryptFileFromListCert(FileName: String;
  Lines: TStrings): Boolean;
var
  I, Num : Integer;
  EncryptParams: TEncryptParams;
  FindParam : TFindParams;
  FindResult : TFindResult;
  ErrorCode : TErrorStatus;
  AllCertsCount : Integer;
  Certificat : TCertificate;
  Certificates : PCertificate;

begin
  Result := False;
  LogMemo.Lines.Add('->   ' + FileName);
  if Trim(Lines.Text) = '' then
  begin
    LogMemo.Lines.Add('->          ... ');
    Exit;
  end;
  AllCertsCount := GetCountSerts(SertLisMemo.Lines);
  if AllCertsCount > 0 then
  begin
    LogMemo.Lines.Add('->  ' + IntToStr(AllCertsCount) + '   ...' );

    FillChar(EncryptParams, SizeOf(EncryptParams), 0);
    FillChar(ErrorCode, SizeOf(ErrorCode), 0);
    try
      GetMem(Certificates, AllCertsCount * Api.CertificateSize);
      with EncryptParams do
      begin
        MyCert := Nil; // 
        ReceiverNum := AllCertsCount;
        Flag := FLAG_PKCS7;
        Receivers := Certificates;
      end;
      for I := 0 to Lines.Count - 1 do
      begin
        FillChar(FindParam, SizeOf(FindParam), 0);
        FillChar(FindResult, SizeOf(FindResult), 0);
        with FindParam do
        begin
          MyCert := Nil; // 
          CertTemplate.Fields := [FIELD_SUBJECT];
          CertTemplate.Subject := PAnsiChar(AnsiString(Trim(Lines.Strings[I])));
          info := [FIELD_SUBJECT]+[FIELD_CERTHASH];
        end;
        ErrorCode := Api.VCERT_FindCert(Context, @FindParam, FindResult);
        if ErrorCode = VCERT_OK then
        begin
          Num := FindResult.Num;
          Move(FindResult.Certs^, Certificates^, Num * Api.CertificateSize);
          Certificates := PCertificate(PAnsiChar(Certificates) + Num * Api.CertificateSize);
        end
        else
        begin
          LogMemo.Lines.Add('->   . Error#=' + IntToStr(ErrorCode) +
                                     ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
          LogMemo.Lines.Add('-> : ' + Lines.Strings[I]);
          Exit;
        end;
      end;
      Certificates := EncryptParams.Receivers;
      ErrorCode := Api.VCERT_EncryptFile(Context, @EncryptParams, PAnsiChar(AnsiString(FileName)),
                                  PAnsiChar(AnsiString(ChangeFileExt(FileName, sSignCrypt))));
      if ErrorCode <> VCERT_OK then
      begin
        LogMemo.Lines.Add('->    ' + FileName + '] Error#=' + IntToStr(ErrorCode) +
                           ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
        Exit;
      end
      else
      begin
        with LogMemo.Lines do
        begin
          Add('->  ' + FileName + ' ..');
          Add('->   ' + ChangeFileExt(FileName, sSignCrypt));
          Add('-> Ok');
        end;
        Result := True;
      end;
    finally
      if Assigned(Certificates) then FreeMem(Certificates);
      Api.VCERT_FreeFindResult(Context, FindResult);
    end;
  end
  else
  begin
    LogMemo.Lines.Add('->       ');
    Exit;
  end;
end;

procedure TMCryptForm.FileReceiveProc(FileName: String);
Var
  ErrorCode : TErrorStatus;
begin
  if AnsiUpperCase(ExtractFileExt(FileName)) <> sSignExt then
  begin
    ErrorCode := VerifyFile(FileName);
    if ErrorCode = VCERT_OK then LogMemo.Lines.Add('->   [' + FileName + ']')
    else LogMemo.Lines.Add('->   [' + FileName + '] Error#=' + IntToStr(ErrorCode) +
                           ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
    if InternalGetSignCount(FileName) > 0 then
    begin
      ErrorCode := DetachSign(FileName, ChangeFileExt(FileName, ''), ChangeFileExt(FileName, sSignExt));
      if ErrorCode <> VCERT_OK then LogMemo.Lines.Add('->      [' + FileName + '] Error#=' + IntToStr(ErrorCode) +
                                                      ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
    end;
  end;
end;

procedure TMCryptForm.FindAllLocalSert;
var
  FindParam : TFindParams;
  FindResult : TFindResult;
  ErrorCode : TErrorStatus;
  I, Num : Integer;
  Certificat : TCertificate;
  Certificates: PCertificate;
begin
  LogMemo.Lines.Add('->     ( )');
  FillChar(FindParam, SizeOf(FindParam), 0);
  FillChar(FindResult, SizeOf(FindResult), 0);
  FillChar(ErrorCode, SizeOf(ErrorCode), 0);
  SertLisMemo.Lines.Clear;
  FindParam.MyCert := Nil;
  FindParam.flag := [FLAG_FIND_ALL];   //[FLAG_FIND_MY];
  FindParam.info := [FIELD_SUBJECT]+[FIELD_CERTHASH];
  try
    ErrorCode := Api.VCERT_FindCert(Context, @FindParam, FindResult);
    if ErrorCode = VCERT_OK then
    begin
      Num := FindResult.Num;
      if Num = 0 then
      begin
        LogMemo.Lines.Add('->      ...');
        Exit;
      end;
      Certificates := PCertificate(FindResult.Certs);
      if Num > 0 then
      begin
        for I := 0 to Num - 1 do
        begin
         SertLisMemo.Lines.Add(Certificates.Subject);
         Certificates := PCertificate(PAnsiChar(Certificates) + Api.CertificateSize);
        end;
        LogMemo.Lines.Add('-> Ok');
      end;
    end
    else
    begin
      LogMemo.Lines.Add('->   . Error#=' + IntToStr(ErrorCode) +
                                       ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
      Exit;
    end;
  finally
    Api.VCERT_FreeFindResult(Context, FindResult);
  end;
end;

procedure TMCryptForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if DirectoryExists(sDir) then RegWriteStr(HKEY_CURRENT_USER, RegBasePathKey, BasePathParamName, sDir);
  RegWriteStr(HKEY_CURRENT_USER, RegBasePathKey, MyCertList, SertLisMemo.Lines.Text);
  RegWriteStr(HKEY_CURRENT_USER, RegBasePathKey, WEBServURL, URLEdit.Text);
  RegWriteStr(HKEY_CURRENT_USER, RegBasePathKey, MyPersonCode, PCodEdit.Text);
end;

procedure TMCryptForm.FormCreate(Sender: TObject);
Var
  _sDir : String;
begin
  SertLisMemo.Lines.Text := RegQueryStr(HKEY_CURRENT_USER, RegBasePathKey, MyCertList);
  _sDir := RegQueryStr(HKEY_CURRENT_USER, RegBasePathKey, BasePathParamName);
  if Trim(_sDir) <> '' then
  if DirectoryExists(_sDir) then sDir := _sDir;
  CryptDirEdit.Text := sDir;
  URLEdit.Text := RegQueryStr(HKEY_CURRENT_USER, RegBasePathKey, WEBServURL);
  PCodEdit.Text := RegQueryStr(HKEY_CURRENT_USER, RegBasePathKey, MyPersonCode);
end;

function TMCryptForm.SignAttachFile(const DataFileName: string): TErrorStatus;
var
  SignParams: TSignParams;
  AddSignFile : String;
  ErrorCode : TErrorStatus;
begin
  if FileExists(ChangeFileExt(DataFileName, sSignExt)) then
  begin
    ErrorCode := AttachSignFile(DataFileName, ChangeFileExt(DataFileName, sSignInt), ChangeFileExt(DataFileName, sSignExt));
  end;
  FillChar(SignParams, SizeOf(SignParams), 0);
  SignParams.MyCert := nil; // 

  AddSignFile := GetTempDir + 'AddSignFile.tmp';
  SignParams.Flag := FLAG_PKCS7 or FLAG_SIGN_SENDCERT;
  if InternalGetSignCount(DataFileName) > 0 then Result := Api.VCERT_SignFile(Context, @SignParams,
                                                             PAnsiChar(AnsiString('')),
                                                             PAnsiChar(AnsiString(DataFileName)),
                                                             PAnsiChar(AnsiString(AddSignFile)))
  else Result := Api.VCERT_SignFile(Context, @SignParams,
                                   PAnsiChar(AnsiString(DataFileName)),
                                   PAnsiChar(AnsiString('')),
                                   PAnsiChar(AnsiString(AddSignFile)));
  if Result = VCERT_OK then
  begin
    if DeleteFile(DataFileName) then
    begin
      if RenameFile(AddSignFile, DataFileName) then LogMemo.Lines.Add('-> Ok');
    end else LogMemo.Lines.Add('->    [' + DataFileName + ']');
  end;
end;

function TMCryptForm.SignDetachFile(const DataFileName,  SignedFileName: string) : TErrorStatus;
var
  SignParams: TSignParams;
  AddSignFile : String;
begin
  if InternalGetSignCount(DataFileName) > 0 then DecryptFile(DataFileName);
  FillChar(SignParams, SizeOf(SignParams), 0);
  SignParams.MyCert := nil; // 

  AddSignFile := GetTempDir + 'AddSignFile.sgn';
  SignParams.Flag := FLAG_PKCS7 or FLAG_DETACHED or FLAG_SIGN_SENDCERT;
  if FileExists(SignedFileName) then
  begin
    Result := Api.VCERT_SignFile(Context, @SignParams,
                                 PAnsiChar(AnsiString(DataFileName)),
                                 PAnsiChar(AnsiString(SignedFileName)),
                                 PAnsiChar(AnsiString(AddSignFile)));
    if Result = VCERT_OK then
    begin
      if DeleteFile(SignedFileName) then
      begin
        if RenameFile(AddSignFile, SignedFileName) then LogMemo.Lines.Add('-> Ok');
      end else LogMemo.Lines.Add('->    [' + SignedFileName + ']');
    end;
  end
  else
  begin
    Result := Api.VCERT_SignFile(Context, @SignParams,
                                    PAnsiChar(AnsiString(DataFileName)),
                                    PAnsiChar(AnsiString('')),
                                    PAnsiChar(AnsiString(SignedFileName)));
    if Result = VCERT_OK then LogMemo.Lines.Add('-> Ok');
  end;
end;

function TMCryptForm.GetCountSerts(Lines: TStrings): Integer;
var
  I : Integer;
begin
  Result := 0;
  for I := 0 to Lines.Count - 1 do
  begin
    Result := Result + GetCountSertOfLine(Lines.Strings[I]);
  end;
end;
procedure TMCryptForm.GetMemHashStream(MemIn: string;
  out AStream: TMemorystream);
var
  HashValue: pointer;
  pb: ^Byte;
  HashLen: integer;
  Hash: TMemBlk;
  HashIn: TMemBlk;

begin
  HashIn.len := Length(MemIn);
  HashIn.buf := PAnsiChar(AnsiString(MemIn));
  Hash := CreateMemBlk(nil, 0);

//  FApi.Default.HashMem(HashIn, Hash);
  Api.VCERT_HashMem(Context, @HashIn, Hash);

  GetMem(HashValue, Hash.len);
  move(Hash.buf^, HashValue^, Hash.Len);
  HashLen := Hash.Len;

//  FApi.Default.FreeMemBlk(Hash);
  with Hash do
  begin
    Api.VCERT_FreeMem(Context, buf);
    buf := nil;
    len := 0;
  end;

  if not Assigned(AStream) then
  begin
    AStream := TMemorystream.Create;
  end;
  AStream.WriteBuffer(HashValue^, HashLen);
  AStream.Position := 0;
end;

function TMCryptForm.GetCountSertOfLine(Line: String): Integer;
var
  FindParam : TFindParams;
  FindResult : TFindResult;
  ErrorCode : TErrorStatus;
  Num : Integer;
begin
  Result := 0;
  FillChar(FindParam, SizeOf(FindParam), 0);
  FillChar(FindResult, SizeOf(FindResult), 0);
  FillChar(ErrorCode, SizeOf(ErrorCode), 0);
  FindParam.MyCert := Nil;
//  FindParam.flag := [FLAG_FIND_ALL];   // [FLAG_FIND_MY];
  FindParam.CertTemplate.Fields := [FIELD_SUBJECT];
  FindParam.CertTemplate.Subject := PAnsiChar(AnsiString(Trim(Line)));
  FindParam.info := [FIELD_SUBJECT]+[FIELD_CERTHASH];
  try
    ErrorCode := Api.VCERT_FindCert(Context, @FindParam, FindResult);
    if ErrorCode = VCERT_OK then
    begin
      Result := FindResult.Num;
    end
    else
    begin
      LogMemo.Lines.Add('->   . Error#=' + IntToStr(ErrorCode) +
                                       ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
      Exit;
    end;
  finally
    Api.VCERT_FreeFindResult(Context, FindResult);
  end;
end;

function TMCryptForm.InternalGetSignCount(SignFileName: string): integer;
var
  SignedInfo: TSignedInfoResult;
  ErrorCode: TErrorStatus;
begin
  LogMemo.Lines.Add('->      ' + SignFileName);
  FillChar(SignedInfo, SizeOf(SignedInfo), 0);
  ErrorCode := Api.VCERT_SignedInfoFile(Context, PAnsiChar(AnsiString(SignFileName)), SignedInfo);
  if ErrorCode = VCERT_OK then Result := SignedInfo.SignNum
  else Result := 0;
  if ErrorCode = VCERT_OK then Api.VCERT_FreeSignedInfoResult(Context, @SignedInfo);
  LogMemo.Lines.Add('->     ' + IntToStr(Result));
end;

procedure TMCryptForm.LogMemoChange(Sender: TObject);
begin // LogMemo
  SendMessage(LogMemo.Handle, EM_SCROLL, SB_LINEDOWN, 0);
end;

function TMCryptForm.DecryptFile(FileName: String): TErrorStatus;
var
  DecryptParams: TDecryptParams;
  DecryptResult: TDecryptResult;

begin
  result := 999999;
  LogMemo.Lines.Add('->   ' + FileName);
  FillChar(DecryptParams, SizeOf(DecryptParams), 0);
  DecryptParams.MyCert := Nil; // 
  DecryptParams.Flag := FLAG_PKCS7;
  DecryptParams.Info := FIELD_ALL;    //[FIELD_SUBJECT]+[FIELD_KEYID];
  FillChar(DecryptResult, SizeOf(DecryptResult), 0);
  try
    Result := Api.VCERT_DecryptFile(Context, @DecryptParams, PAnsiChar(AnsiString(FileName)),
                                PAnsiChar(AnsiString(ChangeFileExt(FileName, '.zip'))), DecryptResult);
    if Result <> VCERT_OK then
    begin
      LogMemo.Lines.Add('->    [' + FileName + '] Error#=' + IntToStr(Result) +
                        ' [' + Api.VCERT_GetErrorText(Result) + ']');
      Exit;
    end
    else
    begin
      LogMemo.Lines.Add('->  ' + FileName + ' ..');
      LogMemo.Lines.Add('->   ' + ChangeFileExt(FileName, '.zip'));
      LogMemo.Lines.Add('-> Ok');
    end;
  finally
    Api.VCERT_FreeDecryptResult(Context, DecryptResult);
  end;
end;

procedure TMCryptForm.SaveLogToolButtonClick(Sender: TObject);
begin
  if SaveTextFileDialog.Execute then LogMemo.Lines.SaveToFile(SaveTextFileDialog.FileName);
end;

function TMCryptForm.ScanDir(sDir: string): Boolean;
var
  iIndex: Integer;
  SearchRec: TSearchRec;
  sFileName: string;
begin
  result := False;
  sDir := IncludeTrailingPathDelimiter(sDir) + '*.*';
  iIndex := FindFirst(sDir, faAnyFile, SearchRec);

  while iIndex = 0 do
  begin
    sFileName := IncludeTrailingPathDelimiter(ExtractFileDir(sDir))+SearchRec.name;
    if (SearchRec.Attr and faDirectory) <> 0 then
    begin
      if ((SearchRec.name <> '' ) and (SearchRec.name <> '.') and (SearchRec.name <> '..')) then
      begin
        ScanDir(sFileName)
      end;
    end
    else FileReceiveProc(sFileName); //
    iIndex := FindNext(SearchRec);
  end;
  FindClose(SearchRec);
  Result := True;
end;

procedure TMCryptForm.SelectDirSButtonClick(Sender: TObject);
begin
  if SelectDirectory('     ', '\', sDir, [sdShowEdit, sdShowShares, sdNewUI]) then
  begin
    CryptDirEdit.Text := IncludeTrailingPathDelimiter(sDir);
  end;
end;

procedure TMCryptForm.SendTrnPackage(FileName: string);
begin
  LogMemo.Lines.Add('->   ' + FileName);
  WebService.SendPackage(FileName);
end;

procedure TMCryptForm.SignFile(FileName: String; SignAttached: boolean);
Var
  ErrorCode : TErrorStatus;
begin
  LogMemo.Lines.Add('->   ' + FileName);
  if SignAttached then
  begin
    ErrorCode := SignAttachFile(FileName);
  end
  else ErrorCode := SignDetachFile(FileName, ChangeFileExt(FileName, sSignExt));
  if ErrorCode = VCERT_OK then LogMemo.Lines.Add('-> Ok')
  else LogMemo.Lines.Add('->    [' + FileName + '] Error#=' + IntToStr(ErrorCode) +
                           ' [' + Api.VCERT_GetErrorText(ErrorCode) + ']');
end;

procedure TMCryptForm.SignStringToStream(Value: AnsiString; Stream: TStream);
var
  FileName, sgnFileName: string;
  fs: TFileStream;
begin
  FileName := GetTempDir + 'tmp.file';
  sgnFileName := ChangeFileExt(FileName, sSignExt);

  fs := TFileStream.Create(FileName, fmCreate);
  try
    fs.WriteBuffer(Pointer(Value)^, Length(Value));
  finally
    fs.Free;
  end;
  if acCryptoInit.Execute then SignFile(FileName, False);
  TMemoryStream(Stream).LoadFromFile(sgnFileName);
  SysUtils.DeleteFile(FileName);
  SysUtils.DeleteFile(sgnFileName);
end;

procedure TMCryptForm.ClearSertListToolButtonClick(Sender: TObject);
begin
  SertLisMemo.Clear;
end;

procedure TMCryptForm.SaveSertListToolButtonClick(Sender: TObject);
begin
  if SaveTextFileDialog.Execute then SertLisMemo.Lines.SaveToFile(SaveTextFileDialog.FileName);
end;

function TMCryptForm.VerifyFile(FileName: String): TErrorStatus;
var
  VerifyParams: TVerifyParams;
  VerifyResult: TVerifyResult;
  ErrorCode: TErrorStatus;
  I : Integer;
begin
  Result := 999999;
  FillChar(VerifyParams, SizeOf(VerifyParams), 0);
  FillChar(VerifyResult, SizeOf(VerifyResult), 0);
  VerifyParams.MyCert := Nil; // 
  VerifyParams.KeyUsage := [KEYUSAGE_DIGITAL_SIGNATURE];
  VerifyParams.Info := FIELD_ALL;
  LogMemo.Lines.Add('->    : ' + FileName);
  try
    if InternalGetSignCount(FileName)>0 then
    begin // 
      VerifyParams.Flag := FLAG_VERIFY_KEYUSAGE or FLAG_VERIFY_NOCACHECERT or FLAG_PKCS7;
      ErrorCode := Api.VCERT_VerifyFile(Context, @VerifyParams,
                                        PAnsiChar(AnsiString('')),
                                        PAnsiChar(AnsiString(FileName)),
                                        PAnsiChar(AnsiString('')), VerifyResult);
    end
    else // 
    begin
      if FileExists(ChangeFileExt(FileName, sSignExt)) then
      begin  // 
        LogMemo.Lines.Add('->    : ' + ChangeFileExt(FileName, sSignExt));
        VerifyParams.Flag := FLAG_VERIFY_KEYUSAGE or FLAG_VERIFY_NOCACHECERT or FLAG_PKCS7 or FLAG_DETACHED;
        ErrorCode := Api.VCERT_VerifyFile(Context, @VerifyParams,
                                          PAnsiChar(AnsiString(FileName)),
                                          PAnsiChar(AnsiString(ChangeFileExt(FileName, sSignExt))),
                                          PAnsiChar(AnsiString('')), VerifyResult);
      end else LogMemo.Lines.Add('-> : ' + FileName + '  ');
    end;
  finally
    for I := 0 to VerifyResult.SignNum - 1 do
    begin
      with LogMemo.Lines do
      begin
        Add('--------------------------------------------------');
        Add('->  #' + IntToStr(I + 1));
        Add('-> Subject: ' + VerifyResult.Signs[I].Cert.Subject);
        Add('-> : ' + DateTimeToStr(UTCToLocalTime(CTime(VerifyResult.Signs[I].Time))));
        Add('-> : ' + Api.VCERT_GetErrorText(VerifyResult.Signs[I].Status));
        Add('--------------------------------------------------');
      end;
      Api.VCERT_FreeMem(Context, VerifyResult.Signs[I].Cert);
    end;
    Api.VCERT_FreeMem(Context, VerifyResult.Signs);
    Result := ErrorCode;
  end;
end;

end.




