package inist.nsdws;

import inist.nsdws.soap.ClientSOAP;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Unit test for NSD.
 */
public class TestSOAP extends TestCase {

    ClientSOAP client;

    @Override
    public void setUp() throws Exception {
        client = new ClientSOAP();
    }


    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public TestSOAP(String testName) {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */

    public static Test suite() {
        return new TestSuite(TestSOAP.class);
    }

    public void testSendPackage() throws Exception {
        File f = new File("packages/W1410002.cry");
        if (!f.exists())
            throw new FileNotFoundException(f.getAbsolutePath());

        client.sendPackage(f);
    }

    public void testGetPackageList() throws Exception {
        Date date = new SimpleDateFormat("dd.MM.yyyy").parse("21.01.2014");
        String packageListXML = client.getPackageList(date);
        System.out.println(packageListXML);
    }
    public void testGetPackage() throws Exception {
        client.getPackage("238735280", "J2114912.CRY", new File("packages"));

    }

}

