package inist.nsdws;

import inist.nsdws.rest.ClientREST;
import inist.nsdws.rest.MarkupBean;
import inist.nsdws.rest.MarkupListBean;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.util.*;

/**
 * Unit test for NSD.
 */
public class TestREST extends TestCase {

    ClientREST client;

    @Override
    public void setUp() throws Exception {
        client = new ClientREST();
        //System.setProperty("javax.net.debug", "ssl");
    }


    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public TestREST(String testName) {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */

    public static Test suite() {
        return new TestSuite(TestREST.class);
    }

    public void testGetMarkups() throws Exception {
        MarkupListBean markups = client.getMarkups();
        System.out.println(markups);
    }

    public void testPutMarkups() throws Exception {
        String[] agreements;
        List<MarkupBean> ml = new ArrayList<>(1);
        agreements = new String[]{"MERR"};
        ml.add(new MarkupBean(Arrays.asList(agreements), "MS9403170087", "00000000000000000", "RU000A0DASA0", 100000007, 100000007));
        ml.add(new MarkupBean(Arrays.asList(agreements), "HS1212170852", "31MC0000500000F00", "1/100_SVAV", 100000, 100000));
        ml.add(new MarkupBean(Arrays.asList(agreements), "HS1212170852", "31MC0000500000F00", "SU46022RMFS8", 1000, 1000));
        ml.add(new MarkupBean(Arrays.asList(agreements), "HS1212170852", "31MC0000500000F00", "XS0767469827", 1, 1));
        ml.add(new MarkupBean(Arrays.asList(agreements), "MS9403170087", "00000000000000000", "XS0767469827", 3000, 3000));
        ml.add(new MarkupBean(Arrays.asList(agreements), "HS1212170852", "31MC0000500000F00", "XS0767469827", null, null));
        ml.add(new MarkupBean(Arrays.asList(agreements), "MS9403170087", "00000000000000000", "RU000A0JPGR4", 10000, 10000));

        agreements = new String[]{"RCBR", "MERR"};
        ml.add(new MarkupBean(Arrays.asList(agreements), "MS9403170087", "00000000000000000", null, null, null));
        ml.add(new MarkupBean(Arrays.asList(agreements), "HS1212170852", "36MC0000500000F00", "RU0007661625", 1000, 1000));

        MarkupListBean markups = new MarkupListBean(
                "1", new Date(), "HS1212170852", "31MC0000500000F00", ml
        );
        client.putMarkups(markups);
    }



}

