package inist.nsdws.soap;

import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.FiltersType;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Description: SSL parametrs initialization
 * User: Jury Rib
 * Date: 02.12.13
 * Time: 14:32
 */
public final class TlsUtil {
    private static final TLSClientParameters tlsParams = new TLSClientParameters();
    private static volatile boolean isTlsSetForSSL = false;
    private static final Lock setTlsParamsLock = new ReentrantLock();

    static TLSClientParameters getTlsParams()
    {
        return tlsParams;
    }

    static void initializeConduitForSSL(Properties pp)
    {
        // if the tls params have not been set up for SSL
        if(!isTlsSetForSSL)
        {
            // get the lock
            setTlsParamsLock.lock();

            // intentionally checking twice to try to minimize overhead
            // of acquiring lock
            if(!isTlsSetForSSL)
            {
                try
                {
                    isTlsSetForSSL = true;

                    // set up the keystore and password
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    // -- provide your password
                    String trustpass = pp.getProperty("keystore.password");
                    // -- provide your truststore
                    File truststore = new File(pp.getProperty("keystore.path", "truststore.jks"));

                    try (InputStream fis = new FileInputStream(truststore)) {
                        keyStore.load(fis, trustpass.toCharArray());
                    }

                    // set the trust store
                    // (decides whether credentials presented by a peer should be accepted)
                    TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustFactory.init(keyStore);
                    TrustManager[] tm = trustFactory.getTrustManagers();
                    tlsParams.setTrustManagers(tm);

                    // set our key store
                    // (used to authenticate the local SSLSocket to its peer)
                    KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyFactory.init(keyStore, trustpass.toCharArray());
                    KeyManager[] km = keyFactory.getKeyManagers();
                    tlsParams.setKeyManagers(km);

                }
                catch(final Exception e)
                {
                    throw new RuntimeException("Failed to initialize conduit!", e);
                }
                finally
                {
                    setTlsParamsLock.unlock();
                }
            }
        }
    }

}
