package inist.nsdws.soap;

import inist.nsdws.common.Crypter;
import inist.nsdws.common.XmlUtil;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.Phase;
import org.apache.xml.security.c14n.Canonicalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.*;

import javax.xml.soap.*;
import java.io.ByteArrayOutputStream;

public class SoapSignOutInterceptor extends AbstractSoapInterceptor {
    final Logger logger = LoggerFactory.getLogger(SoapSignOutInterceptor.class);

    public static final String BODY_ID = "NRDRequest";
    public static final String C14N_ALGORITHM = Canonicalizer.ALGO_ID_C14N_EXCL_OMIT_COMMENTS;

    private Crypter crypter;
    private boolean pkcs7;

    static{
        org.apache.xml.security.Init.init();
    }

    public SoapSignOutInterceptor() {
        super(Phase.USER_PROTOCOL);
        getAfter().add(SAAJOutInterceptor.class.getName());
    }

    public Crypter getCrypter() {
        return crypter;
    }

    public void setCrypter(Crypter crypter) {
        this.crypter = crypter;
    }

    public boolean isPkcs7() {
        return pkcs7;
    }

    public void setPkcs7(boolean pkcs7) {
        this.pkcs7 = pkcs7;
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        SOAPMessage sm = message.getContent(SOAPMessage.class);
        if(logger.isDebugEnabled()){
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
                sm.writeTo(baos);
                logger.debug("SOAP before sign: "+ new String(baos.toByteArray(),"UTF-8") );
            } catch (Exception e) {
                logger.debug("Error writing SOAPMessage content for debug", e);
            }
        }
        try {
            SOAPFactory sf = SOAPFactory.newInstance();
            SOAPHeader sh = sm.getSOAPHeader();
            if (sh == null) {
                sh = sm.getSOAPPart().getEnvelope().addHeader();
            }
/*
            if (id == null || id.isEmpty()) soapBody.setAttribute("wsu:Id", BODY_ID);
*/

            Name name = sf.createName("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            SOAPHeaderElement securityEl = sh.addHeaderElement(name);

            securityEl.addNamespaceDeclaration("wsu","http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            //add wsu:id to SOAP BODY
            SOAPBody soapBody = sm.getSOAPBody();
            String id = BODY_ID;
            soapBody.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);

            SOAPElement signatureEl = securityEl.addChildElement("Signature", "ds", "http://www.w3.org/2000/09/xmldsig#");
            SOAPElement signedInfoEl = signatureEl.addChildElement("SignedInfo", "ds");
            SOAPElement canonMethodEl = signedInfoEl.addChildElement("CanonicalizationMethod", "ds")
                    .addAttribute(sf.createName("Algorithm"), C14N_ALGORITHM);
            SOAPElement signMethodEl = signedInfoEl.addChildElement("SignatureMethod", "ds")
                    .addAttribute(sf.createName("Algorithm"), "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            SOAPElement referenseEl = signedInfoEl.addChildElement("Reference", "ds")
                    .addAttribute(sf.createName("URI"), '#' + id);
            SOAPElement transformsEl = referenseEl.addChildElement("Transforms", "ds");
            SOAPElement transformEl = transformsEl.addChildElement("Transform", "ds")
                    .addAttribute(sf.createName("Algorithm"), C14N_ALGORITHM);
            SOAPElement digestMethodEl = referenseEl.addChildElement("DigestMethod", "ds")
                    .addAttribute(sf.createName("Algorithm"), "http://www.w3.org/2000/09/xmldsig#sha1");
            SOAPElement digestValueEl = referenseEl.addChildElement("DigestValue", "ds");


            String digest = makeDigest(soapBody);
            digestValueEl.addTextNode(digest);

            //make signature
            String signature = makeSignature(signedInfoEl);
            SOAPElement signatureValueEl = signatureEl.addChildElement("SignatureValue", "ds");
            signatureValueEl.addTextNode(signature);
        } catch (Exception e) {
            throw new Fault(e);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            sm.writeTo(baos);
            logger.debug("SOAP after sign: "+ new String(baos.toByteArray(),"UTF-8") );
        } catch (Exception e) {
            logger.debug("Error writing SOAPMessage content for debug", e);
        }

    }

        //canonicalization
    private byte[] c14n(SOAPElement el) throws Exception {
        //org.w3c.dom.Node node = XmlUtil.extractNode(el.cloneNode(true));
        //Node node1= XmlUtil.extractNode(node);
        String node1Str = XmlUtil.toString(el);
        Document doc1 = XmlUtil.toXML(node1Str);
        Canonicalizer c14n = Canonicalizer.getInstance(C14N_ALGORITHM);
        byte[] bb = c14n.canonicalizeSubtree(doc1, "");
        return bb;

    }

    private String makeDigest(SOAPElement el) throws Exception {
        //canonicalization
        byte[] bb = c14n(el);
        String digest = crypter.digestSHA1(bb);
        return digest;
    }

    private String makeSignature(SOAPElement el) throws Exception {
        //canonicalization
        byte[] bb = c14n(el);
        String sign;
        if (!pkcs7) {
            sign = crypter.rsaSignData(bb);
        } else {
            sign = crypter.makePKCS7(bb);
        }
        return sign;
    }

}
