package inist.nsdws.soap;

import org.apache.ws.security.WSPasswordCallback;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;

import java.io.IOException;

/**
 * Simple password callback handler. This just checks if the password for the private key
 * is being requested, and if so sets that value.
 */
public class PWDCallbackHandler implements CallbackHandler
{
    private String user="";
    private String password;

    public void handle(Callback[] callbacks) throws IOException {
        if(user==null) throw new IOException("PWDCallbackHandler not initialized yet");
        for (Callback callback : callbacks) {
            WSPasswordCallback pwcb = (WSPasswordCallback) callback;
            String id = pwcb.getIdentifier();
            int usage = pwcb.getUsage();
            if (usage == WSPasswordCallback.DECRYPT || usage == WSPasswordCallback.SIGNATURE) {
                //used to retrieve password for private key
                if (user.equals(id)) {
                    pwcb.setPassword(password);
                }

            }
        }
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}