package inist.nsdws.rest;

import com.google.gson.annotations.SerializedName;

import java.util.Date;
import java.util.List;

/**
 * Description:
 * User: Jury Rib
 * Date: 21.11.13
 * Time: 17:20
 */
public class MarkupListBean {
    //Номер документа (required)
    @SerializedName("doc_no")
    private String docNo;

    //Дата-время формирования (required)
    @SerializedName("doc_date_time")
    private Date docDateTime;

    //Счет депо для вывода
    @SerializedName("acc_out")
    private String accountOut;

    //Раздел счета депо для вывода
    @SerializedName("section_out")
    private String sectionOut;

    //Список маркирования (required)
    @SerializedName("markups")
    private List<MarkupBean> markups;

    public MarkupListBean() {
    }

    public MarkupListBean(String docNo, Date docDateTime, String accountOut, String sectionOut,
                          List<MarkupBean> markups) {
        this.docNo = docNo;
        this.docDateTime = docDateTime;
        this.accountOut = accountOut;
        this.sectionOut = sectionOut;
        this.markups = markups;
    }

    public String getDocNo() {
        return docNo;
    }

    public void setDocNo(String docNo) {
        this.docNo = docNo;
    }

    public Date getDocDateTime() {
        return docDateTime;
    }

    public void setDocDateTime(Date docDateTime) {
        this.docDateTime = docDateTime;
    }

    public String getAccountOut() {
        return accountOut;
    }

    public void setAccountOut(String accountOut) {
        this.accountOut = accountOut;
    }

    public String getSectionOut() {
        return sectionOut;
    }

    public void setSectionOut(String sectionOut) {
        this.sectionOut = sectionOut;
    }

    public List<MarkupBean> getMarkups() {
        return markups;
    }

    public void setMarkups(List<MarkupBean> markups) {
        this.markups = markups;
    }

    @Override
    public String toString() {
        return "MarkupListBean{" +
                "docNo='" + docNo + '\'' +
                ", docDateTime=" + docDateTime +
                ", accountOut='" + accountOut + '\'' +
                ", sectionOut='" + sectionOut + '\'' +
                ", markups=" + markups +
                '}';
    }
}
