package inist.nsdws.rest;

import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Description:
 * User: Jury Rib
 * Date: 21.11.13
 * Time: 17:25
 */
public class MarkupBean {
    //коды Генеральных соглашений (required)
    @SerializedName("agr_codes")
    private List<String> agreementCodes;

    //номер счета депо участника (required)
    @SerializedName("acc_code")
    private String accountCode;

    //раздел счета депо участника
    @SerializedName("section_code")
    private String sectionCode;

    //код ценной бумаги
    @SerializedName("security_code")
    private String securityCode;

    //кол-во цб (1)
    @SerializedName("quantity1")
    private Integer quantity1;

    //кол-во цб (2)
    @SerializedName("quantity2")
    private Integer quantity2;

    public MarkupBean() {
    }

    public MarkupBean(List<String> agreementCodes, String accountCode, String sectionCode,
                      String securityCode, Integer quantity1, Integer quantity2) {
        this.agreementCodes = agreementCodes;
        this.accountCode = accountCode;
        this.sectionCode = sectionCode;
        this.securityCode = securityCode;
        this.quantity1 = quantity1;
        this.quantity2 = quantity2;
    }

    public List<String> getAgreementCodes() {
        return agreementCodes;
    }

    public void setAgreementCodes(List<String> agreementCodes) {
        this.agreementCodes = agreementCodes;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public String getSectionCode() {
        return sectionCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public String getSecurityCode() {
        return securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public Integer getQuantity1() {
        return quantity1;
    }

    public void setQuantity1(Integer quantity1) {
        this.quantity1 = quantity1;
    }

    public Integer getQuantity2() {
        return quantity2;
    }

    public void setQuantity2(Integer quantity2) {
        this.quantity2 = quantity2;
    }

    @Override
    public String toString() {
        return "MarkupBean{" +
                "agreementCodes=" + agreementCodes +
                ", accountCode='" + accountCode + '\'' +
                ", sectionCode='" + sectionCode + '\'' +
                ", securityCode='" + securityCode + '\'' +
                ", quantity1=" + quantity1 +
                ", quantity2=" + quantity2 +
                '}';
    }
}
