package inist.nsdws.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.*;

/**
 * Description:
 * User: Jury Rib
 * Date: 19.12.13
 * Time: 15:00
 */
public class XmlUtil {

    public static String toString(Node node) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        //transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "false");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        String output = writer.getBuffer().toString();
        return output;
    }

    private static Document toXML(InputSource inputSource) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputSource);
        return doc;
    }

    public static Document toXML(InputStream stream) throws Exception {
        return toXML(new InputSource(stream));
    }

    public static Document toXML(File f) throws Exception {
        return toXML(new FileInputStream(f));
    }

    public static Document toXML(String string) throws Exception {
        return toXML(new InputSource(new StringReader(string)));
    }

}
