package inist.nsdws.common;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.security.Security;
import java.util.Properties;

/**
 * Description:
 * User: Jury Rib
 * Date: 25.11.13
 * Time: 11:48
 */
public class ClientBase {
    final Logger logger = LoggerFactory.getLogger(ClientBase.class);
    protected Properties properties;

    static {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.insertProviderAt(provider, 1);
    }

    public ClientBase() throws IOException, NSDException {
        properties = new Properties();
        //load program properties
        InputStream in = null;
        try {
            in = getClass().getClassLoader().getResourceAsStream("nsdws.properties");
            if (in == null) {
                File f = new File("nsdws.properties");
                if (f.exists()) {
                    in = new FileInputStream(f);
                    logger.info("Loading properties from file...");
                }
            } else {
                logger.info("Loading properties from classpath...");
            }
            if (in != null) properties.load(in);
            else throw new NSDException("Инициализационный файл nsdws.properties не обнаружен");
        } finally {
            if (in != null) in.close();
        }
        //check keystore path
        String keystorePath = properties.getProperty("keystore.path");
        if (keystorePath == null) throw new IllegalArgumentException("Не задан путь к хранилищу ключей");

        //check keystore password
        String keystorePassword = properties.getProperty("keystore.password");
        if (keystorePassword == null) throw new IllegalArgumentException("Не задан пароль доступа к хранилищу ключей");
        //SSL Initialization, keystore
        System.setProperty("javax.net.ssl.keyStore", keystorePath);
        System.setProperty("javax.net.ssl.keyStorePassword", keystorePassword);

        //SSL Initialization, truststore
        String truststorePath = properties.getProperty("truststore.path");
        if (truststorePath != null) {
            System.setProperty("javax.net.ssl.trustStore", truststorePath);
            String truststorePassword = properties.getProperty("truststore.password");
            if (truststorePassword != null)
                System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);
        } else {
            //assume the same as keystore
            System.setProperty("javax.net.ssl.trustStore", keystorePath);
            System.setProperty("javax.net.ssl.trustStorePassword", keystorePassword);
        }
    }

}
