/*
 * Decompiled with CFR 0.152.
 */
package inist.nsdws.soap;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;

public final class TlsUtil {
    private static final TLSClientParameters tlsParams = new TLSClientParameters();
    private static volatile boolean isTlsSetForSSL = false;
    private static final Lock setTlsParamsLock = new ReentrantLock();

    static TLSClientParameters getTlsParams() {
        return tlsParams;
    }

    static void initializeConduitForSSL(Properties pp) {
        if (!isTlsSetForSSL) {
            setTlsParamsLock.lock();
            if (!isTlsSetForSSL) {
                try {
                    isTlsSetForSSL = true;
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    String trustpass = pp.getProperty("keystore.password");
                    File truststore = new File(pp.getProperty("keystore.path", "truststore.jks"));
                    try (FileInputStream fis = new FileInputStream(truststore);){
                        keyStore.load(fis, trustpass.toCharArray());
                    }
                    TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustFactory.init(keyStore);
                    TrustManager[] tm = trustFactory.getTrustManagers();
                    tlsParams.setTrustManagers(tm);
                    KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyFactory.init(keyStore, trustpass.toCharArray());
                    KeyManager[] km = keyFactory.getKeyManagers();
                    tlsParams.setKeyManagers(km);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize conduit!", e);
                }
                finally {
                    setTlsParamsLock.unlock();
                }
            }
        }
    }
}

