/*
 * Decompiled with CFR 0.152.
 */
package inist.nsdws.soap;

import inist.nsdws.common.Crypter;
import inist.nsdws.common.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SoapSignOutInterceptor
extends AbstractSoapInterceptor {
    final Logger logger = LoggerFactory.getLogger(SoapSignOutInterceptor.class);
    public static final String BODY_ID = "NRDRequest";
    public static final String C14N_ALGORITHM = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private Crypter crypter;
    private boolean pkcs7;

    public SoapSignOutInterceptor() {
        super("user-protocol");
        this.getAfter().add(SAAJOutInterceptor.class.getName());
    }

    public Crypter getCrypter() {
        return this.crypter;
    }

    public void setCrypter(Crypter crypter) {
        this.crypter = crypter;
    }

    public boolean isPkcs7() {
        return this.pkcs7;
    }

    public void setPkcs7(boolean pkcs7) {
        this.pkcs7 = pkcs7;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        ByteArrayOutputStream baos;
        SOAPMessage sm = (SOAPMessage)message.getContent(SOAPMessage.class);
        if (this.logger.isDebugEnabled()) {
            try {
                baos = new ByteArrayOutputStream(256);
                sm.writeTo((OutputStream)baos);
                this.logger.debug("SOAP before sign: " + new String(baos.toByteArray(), "UTF-8"));
            }
            catch (Exception e) {
                this.logger.debug("Error writing SOAPMessage content for debug", (Throwable)e);
            }
        }
        try {
            SOAPFactory sf = SOAPFactory.newInstance();
            SOAPHeader sh = sm.getSOAPHeader();
            if (sh == null) {
                sh = sm.getSOAPPart().getEnvelope().addHeader();
            }
            Name name = sf.createName("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            SOAPHeaderElement securityEl = sh.addHeaderElement(name);
            securityEl.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPBody soapBody = sm.getSOAPBody();
            String id = BODY_ID;
            soapBody.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
            SOAPElement signatureEl = securityEl.addChildElement("Signature", "ds", "http://www.w3.org/2000/09/xmldsig#");
            SOAPElement signedInfoEl = signatureEl.addChildElement("SignedInfo", "ds");
            SOAPElement canonMethodEl = signedInfoEl.addChildElement("CanonicalizationMethod", "ds").addAttribute(sf.createName("Algorithm"), C14N_ALGORITHM);
            SOAPElement signMethodEl = signedInfoEl.addChildElement("SignatureMethod", "ds").addAttribute(sf.createName("Algorithm"), "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            SOAPElement referenseEl = signedInfoEl.addChildElement("Reference", "ds").addAttribute(sf.createName("URI"), '#' + id);
            SOAPElement transformsEl = referenseEl.addChildElement("Transforms", "ds");
            SOAPElement transformEl = transformsEl.addChildElement("Transform", "ds").addAttribute(sf.createName("Algorithm"), C14N_ALGORITHM);
            SOAPElement digestMethodEl = referenseEl.addChildElement("DigestMethod", "ds").addAttribute(sf.createName("Algorithm"), "http://www.w3.org/2000/09/xmldsig#sha1");
            SOAPElement digestValueEl = referenseEl.addChildElement("DigestValue", "ds");
            String digest = this.makeDigest((SOAPElement)soapBody);
            digestValueEl.addTextNode(digest);
            String signature = this.makeSignature(signedInfoEl);
            SOAPElement signatureValueEl = signatureEl.addChildElement("SignatureValue", "ds");
            signatureValueEl.addTextNode(signature);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        try {
            baos = new ByteArrayOutputStream(256);
            sm.writeTo((OutputStream)baos);
            this.logger.debug("SOAP after sign: " + new String(baos.toByteArray(), "UTF-8"));
        }
        catch (Exception e) {
            this.logger.debug("Error writing SOAPMessage content for debug", (Throwable)e);
        }
    }

    private byte[] c14n(SOAPElement el) throws Exception {
        String node1Str = XmlUtil.toString((Node)el);
        Document doc1 = XmlUtil.toXML(node1Str);
        Canonicalizer c14n = Canonicalizer.getInstance((String)C14N_ALGORITHM);
        byte[] bb = c14n.canonicalizeSubtree((Node)doc1, "");
        return bb;
    }

    private String makeDigest(SOAPElement el) throws Exception {
        byte[] bb = this.c14n(el);
        String digest = this.crypter.digestSHA1(bb);
        return digest;
    }

    private String makeSignature(SOAPElement el) throws Exception {
        byte[] bb = this.c14n(el);
        String sign = !this.pkcs7 ? this.crypter.rsaSignData(bb) : this.crypter.makePKCS7(bb);
        return sign;
    }

    static {
        Init.init();
    }
}

