/*
 * Decompiled with CFR 0.152.
 */
package inist.nsdws.soap;

import inist.nsdws.common.ClientBase;
import inist.nsdws.common.NSDException;
import inist.nsdws.soap.TlsUtil;
import inist.nsdws.soap.gen.ByteResult;
import inist.nsdws.soap.gen.FaultInfo;
import inist.nsdws.soap.gen.PutPackage;
import inist.nsdws.soap.gen.StringResult;
import inist.nsdws.soap.gen.WsFault;
import inist.nsdws.soap.gen.Wsl;
import inist.nsdws.soap.gen.WslService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.internet.InternetHeaders;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSOAP
extends ClientBase {
    final Logger logger = LoggerFactory.getLogger(ClientSOAP.class);
    private final String nsdMemberCode;
    private String serviceEndPointURL;

    private Wsl createPort() {
        WslService ss = new WslService();
        Wsl port = ss.getWslPort();
        if (this.serviceEndPointURL != null) {
            Map ctx = ((BindingProvider)port).getRequestContext();
            ctx.put("javax.xml.ws.service.endpoint.address", this.serviceEndPointURL);
        }
        Client client = ClientProxy.getClient((Object)port);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        http.setTlsClientParameters(TlsUtil.getTlsParams());
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setAllowChunking(false);
        httpClientPolicy.setConnectionTimeout(360000L);
        httpClientPolicy.setReceiveTimeout(360000L);
        http.setClient(httpClientPolicy);
        return port;
    }

    public ClientSOAP() throws Exception {
        this.logger.info("Start SOAP WS client initialization");
        this.nsdMemberCode = this.properties.getProperty("nsd.memberCode");
        if (this.nsdMemberCode == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u041d\u0420\u0414");
        }
        this.serviceEndPointURL = this.properties.getProperty("soap.service.URI");
        String keystorePath = this.properties.getProperty("keystore.path");
        if (keystorePath == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0443\u0442\u044c \u043a \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443 \u043a\u043b\u044e\u0447\u0435\u0439");
        }
        String keystorePassword = this.properties.getProperty("keystore.password");
        if (keystorePassword == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443 \u043a\u043b\u044e\u0447\u0435\u0439");
        }
        String privateKeyAlias = this.properties.getProperty("privateKey.alias");
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 (alias) \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430 \u0432 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        }
        TlsUtil.initializeConduitForSSL(this.properties);
        this.logger.info("SOAP WS client initialized");
    }

    public void sendPackage(File file) throws Exception {
        String packageId;
        Wsl port = this.createPort();
        try {
            this.logger.debug("InitTransferIn started");
            StringResult result = port.initTransferIn(this.nsdMemberCode, file.getName());
            packageId = result.getData();
            System.out.println("InitTransferIn: PackageID=" + packageId);
            this.logger.debug("InitTransferIn finished");
        }
        catch (WsFault e) {
            this.logger.error("InitTransferIn error", (Throwable)e);
            FaultInfo faultInfo = e.getFaultInfo();
            if (faultInfo != null) {
                throw new NSDException(faultInfo.getErrorCode(), faultInfo.getErrorDesc(), e);
            }
            throw e;
        }
        try {
            String id = "package1";
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-Type", "application/binary");
            headers.addHeader("Content-ID", id);
            headers.addHeader("Content-Transfer-Encoding", "binary");
            byte[] bb = IOUtils.readBytesFromStream((InputStream)new FileInputStream(file));
            ByteArrayInputStream bais = new ByteArrayInputStream(bb);
            Attachment attach = AttachmentUtil.createAttachment((InputStream)bais, (InternetHeaders)headers);
            attachments.add(attach);
            BindingProvider bp = (BindingProvider)port;
            Map reqContext = bp.getRequestContext();
            reqContext.put(Message.ATTACHMENTS, attachments);
            this.logger.debug("PutPackage started");
            PutPackage.PackageBody packageBody = new PutPackage.PackageBody();
            packageBody.setHref("cid:" + id);
            port.putPackage(this.nsdMemberCode, packageId, 1, 1, packageBody);
            this.logger.debug("PutPackage finished");
        }
        catch (WsFault e) {
            this.logger.error("PutPackage error", (Throwable)e);
            FaultInfo faultInfo = e.getFaultInfo();
            if (faultInfo != null) {
                throw new NSDException(faultInfo.getErrorCode(), faultInfo.getErrorDesc(), e);
            }
            throw e;
        }
        try {
            this.logger.debug("GetTransferResult started");
            port.getTransferResult(this.nsdMemberCode, packageId);
            this.logger.debug("GetTransferResult finished");
        }
        catch (WsFault e) {
            this.logger.error("GetTransferResult error", (Throwable)e);
            FaultInfo faultInfo = e.getFaultInfo();
            if (faultInfo != null) {
                throw new NSDException(faultInfo.getErrorCode(), faultInfo.getErrorDesc(), e);
            }
            throw e;
        }
    }

    public String getPackageList(Date date) throws Exception {
        String packageListXML;
        Wsl port = this.createPort();
        try {
            this.logger.debug("GetPackageList started");
            String dateStr = new SimpleDateFormat("dd.MM.yyyy").format(date);
            StringResult result = port.getPackageList(this.nsdMemberCode, dateStr);
            packageListXML = result.getData();
            System.out.println("GetPackageList: packageListXML=" + packageListXML);
            this.logger.debug("GetPackageList finished");
        }
        catch (WsFault e) {
            this.logger.error("GetPackageList error", (Throwable)e);
            FaultInfo faultInfo = e.getFaultInfo();
            if (faultInfo != null) {
                throw new NSDException(faultInfo.getErrorCode(), faultInfo.getErrorDesc(), e);
            }
            throw e;
        }
        return packageListXML;
    }

    public void getPackage(String packageId, String fileName, File directoryOut) throws Exception {
        if (directoryOut != null && !directoryOut.exists() && !directoryOut.mkdir()) {
            throw new NSDException("Can't create output directory: " + directoryOut.getAbsolutePath());
        }
        Wsl port = this.createPort();
        try {
            this.logger.debug("GetPackage started. PackageId=" + packageId);
            ByteResult result = port.getPackage(this.nsdMemberCode, packageId, 1, 1);
            result.getData();
            BindingProvider bp = (BindingProvider)port;
            Map respContext = bp.getResponseContext();
            Collection attachments = (Collection)respContext.get(Message.ATTACHMENTS);
            if (attachments == null || attachments.size() == 0) {
                throw new NSDException("Attachments not found in GetPackage response");
            }
            DataHandler dataHandler = ((Attachment)attachments.iterator().next()).getDataHandler();
            try (FileOutputStream os = new FileOutputStream(new File(directoryOut, fileName));){
                IOUtils.copyAndCloseInput((InputStream)dataHandler.getInputStream(), (OutputStream)os);
            }
            this.logger.debug("GetPackage finished. File " + fileName + " saved");
        }
        catch (WsFault e) {
            this.logger.error("GetPackage error", (Throwable)e);
            FaultInfo faultInfo = e.getFaultInfo();
            if (faultInfo != null) {
                throw new NSDException(faultInfo.getErrorCode(), faultInfo.getErrorDesc(), e);
            }
            throw e;
        }
    }
}

