/*
 * Decompiled with CFR 0.152.
 */
package inist.nsdws.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import inist.nsdws.common.ClientBase;
import inist.nsdws.common.Crypter;
import inist.nsdws.common.NSDException;
import inist.nsdws.rest.MarkupListBean;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientREST
extends ClientBase {
    public static final String CHARSET = "UTF-8";
    final Logger logger = LoggerFactory.getLogger(ClientREST.class);
    private final String serviceURI = this.properties.getProperty("rest.service.URI");
    private final String serviceVersion;
    private String memberCode;
    private Crypter crypter;

    public ClientREST() throws Exception {
        if (this.serviceURI == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URI REST-\u0441\u0435\u0440\u0432\u0438\u0441\u0430");
        }
        this.serviceVersion = this.properties.getProperty("rest.service.version", "1");
        this.memberCode = this.properties.getProperty("nsd.memberCode");
        if (this.memberCode == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u041d\u0420\u0414");
        }
        String keystorePath = this.properties.getProperty("keystore.path");
        if (keystorePath == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0443\u0442\u044c \u043a \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443 \u043a\u043b\u044e\u0447\u0435\u0439");
        }
        String keystorePassword = this.properties.getProperty("keystore.password");
        if (keystorePassword == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443 \u043a\u043b\u044e\u0447\u0435\u0439");
        }
        String privateKeyAlias = this.properties.getProperty("privateKey.alias");
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 (alias) \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430 \u0432 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        }
        String nsdCertAlias = this.properties.getProperty("serverCert.alias");
        if (nsdCertAlias == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 (alias) \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0432 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        }
        this.crypter = new Crypter(keystorePath, keystorePassword, privateKeyAlias, nsdCertAlias);
    }

    public MarkupListBean getMarkups() throws Exception {
        MarkupListBean markups;
        block8: {
            String signedURLPart = "/v" + this.serviceVersion + "/participants/" + this.memberCode + "/markups";
            String fullURL = this.serviceURI + signedURLPart;
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(fullURL);
            method.addRequestHeader("Content-Type", "text/html; charset=UTF-8");
            String certificate = this.crypter.getCertificateBase64();
            method.addRequestHeader("X-CLIENTCERT", certificate);
            String signature = this.crypter.makePKCS7(signedURLPart.getBytes(CHARSET));
            method.addRequestHeader("X-WSALAM-SIGN", signature);
            markups = null;
            try {
                this.logger.debug("getMarkup request " + fullURL);
                int statusCode = client.executeMethod((HttpMethod)method);
                this.logger.debug("getMarkup response status " + statusCode);
                byte[] responseBody = method.getResponseBody();
                String result = responseBody == null ? null : new String(responseBody, CHARSET);
                this.logger.debug("getMarkup response body: " + result);
                if (statusCode == 200) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").create();
                    markups = (MarkupListBean)gson.fromJson(result, MarkupListBean.class);
                    break block8;
                }
                String errorMessage = null;
                if (result != null) {
                    errorMessage = this.parseErrorJson(result);
                }
                throw new NSDException(statusCode, errorMessage);
            }
            catch (HttpException e) {
                this.logger.error("Fatal protocol violation", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                this.logger.error("Fatal transport error", (Throwable)e);
                throw e;
            }
            finally {
                method.releaseConnection();
            }
        }
        return markups;
    }

    private String parseErrorJson(String resultJson) {
        String error;
        try {
            Gson gson = new Gson();
            error = (String)gson.fromJson(resultJson, String.class);
        }
        catch (JsonSyntaxException e) {
            error = resultJson;
        }
        return error;
    }

    public void putMarkups(MarkupListBean markups) throws Exception {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").create();
        String json = gson.toJson((Object)markups);
        String signedURLPart = "/v" + this.serviceVersion + "/participants/" + this.memberCode + "/markups";
        String fullURL = this.serviceURI + signedURLPart;
        HttpClient client = new HttpClient();
        PutMethod method = new PutMethod(fullURL);
        method.setRequestHeader("Cache-Control", "no-cache");
        String certificate = this.crypter.getCertificateBase64();
        method.addRequestHeader("X-CLIENTCERT", certificate);
        String signature = this.crypter.makePKCS7((signedURLPart + json).getBytes(CHARSET));
        method.addRequestHeader("X-WSALAM-SIGN", signature);
        method.setRequestEntity((RequestEntity)new StringRequestEntity(json, "application/json", CHARSET));
        try {
            this.logger.debug("postMarkup request " + fullURL);
            int statusCode = client.executeMethod((HttpMethod)method);
            this.logger.debug("postMarkup response status " + statusCode);
            byte[] responseBody = method.getResponseBody();
            String result = responseBody == null ? null : new String(responseBody, CHARSET);
            this.logger.debug("postMarkup response body: " + result);
            if (statusCode != 200 && statusCode != 201) {
                String errorMessage = null;
                if (result != null) {
                    errorMessage = this.parseErrorJson(result);
                }
                throw new NSDException(statusCode, errorMessage);
            }
        }
        catch (HttpException e) {
            this.logger.error("Fatal protocol violation", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.logger.error("Fatal transport error", (Throwable)e);
            throw e;
        }
        finally {
            method.releaseConnection();
        }
    }
}

