/*
 * Decompiled with CFR 0.152.
 */
package inist.nsdws.common;

import inist.nsdws.common.CryptoException;
import inist.nsdws.common.NSDException;
import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class Crypter {
    private RSAPrivateCrtKey privateKey;
    private X509Certificate pkCertificate;
    private X509Certificate nsdCertificate;
    private String base64Cert;

    public Crypter(String keyStorePath, String password, String privateKeyAlias, String nsdCertAlias) throws CryptoException {
        if (privateKeyAlias == null) {
            throw new CryptoException("Private key alias not specified");
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                keyStore.load(fis, password.toCharArray());
            }
            this.pkCertificate = (X509Certificate)keyStore.getCertificate(privateKeyAlias);
            byte[] certificateBody = this.pkCertificate.getEncoded();
            this.base64Cert = Base64.toBase64String((byte[])certificateBody);
            this.privateKey = (RSAPrivateCrtKey)keyStore.getKey(privateKeyAlias, password.toCharArray());
            this.nsdCertificate = (X509Certificate)keyStore.getCertificate(nsdCertAlias);
        }
        catch (Exception e) {
            throw new CryptoException("KeyStore init error", e);
        }
    }

    public String getCertificateBase64() {
        return this.base64Cert;
    }

    public RSAPrivateCrtKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.pkCertificate;
    }

    public String rsaSignData(byte[] body) throws GeneralSecurityException {
        Signature sign = Signature.getInstance("Sha1WithRSA");
        sign.initSign(this.privateKey);
        sign.update(body);
        byte[] bb = sign.sign();
        return Base64.toBase64String((byte[])bb);
    }

    public String digestSHA1(byte[] body) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] digest = md.digest(body);
        return Base64.toBase64String((byte[])digest);
    }

    public String makePKCS7(byte[] dataToSign) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(1);
        CMSProcessableByteArray msg = new CMSProcessableByteArray(dataToSign);
        certList.add(this.pkCertificate);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build((PrivateKey)this.privateKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, this.pkCertificate));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, false);
        byte[] bb = sigData.getEncoded();
        return Base64.toBase64String((byte[])bb);
    }

    public void verifyPKCS7(byte[] sigData) throws Exception {
        CMSSignedData s = new CMSSignedData(sigData);
        Store store = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        for (Object o : c) {
            SignerInformation signer = (SignerInformation)o;
            Collection certCollection = store.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
            if (!certHolder.getSerialNumber().equals(this.nsdCertificate.getSerialNumber())) {
                throw new NSDException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438: \u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0432 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 (SN=" + certHolder.getSerialNumber() + ") \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0443 NSD(CN=" + this.nsdCertificate.getSerialNumber() + ") ");
            }
            if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(this.nsdCertificate))) continue;
            throw new NSDException("\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u043d\u0435 \u0432\u0435\u0440\u043d\u0430");
        }
    }
}

