/*
 * Decompiled with CFR 0.152.
 */
package inist.nsdws.common;

import inist.nsdws.common.NSDException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBase {
    final Logger logger;
    protected Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBase() throws IOException, NSDException {
        block13: {
            this.logger = LoggerFactory.getLogger(ClientBase.class);
            this.properties = new Properties();
            try (InputStream in = null;){
                in = this.getClass().getClassLoader().getResourceAsStream("nsdws.properties");
                if (in == null) {
                    File f = new File("nsdws.properties");
                    if (f.exists()) {
                        in = new FileInputStream(f);
                        this.logger.info("Loading properties from file...");
                    }
                } else {
                    this.logger.info("Loading properties from classpath...");
                }
                if (in != null) {
                    this.properties.load(in);
                    break block13;
                }
                throw new NSDException("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b nsdws.properties \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
            }
        }
        String keystorePath = this.properties.getProperty("keystore.path");
        if (keystorePath == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0443\u0442\u044c \u043a \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443 \u043a\u043b\u044e\u0447\u0435\u0439");
        }
        String keystorePassword = this.properties.getProperty("keystore.password");
        if (keystorePassword == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443 \u043a\u043b\u044e\u0447\u0435\u0439");
        }
        System.setProperty("javax.net.ssl.keyStore", keystorePath);
        System.setProperty("javax.net.ssl.keyStorePassword", keystorePassword);
        String truststorePath = this.properties.getProperty("truststore.path");
        if (truststorePath != null) {
            System.setProperty("javax.net.ssl.trustStore", truststorePath);
            String truststorePassword = this.properties.getProperty("truststore.password");
            if (truststorePassword != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);
            }
        } else {
            System.setProperty("javax.net.ssl.trustStore", keystorePath);
            System.setProperty("javax.net.ssl.trustStorePassword", keystorePassword);
        }
    }

    static {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.insertProviderAt((Provider)provider, 1);
    }
}

